/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.services;

import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.Row;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.boot.admin.services.AppUserService;
import com.litongjava.tio.boot.admin.vo.AppUserLoginVo;
import com.litongjava.tio.boot.admin.vo.GoogleJwtPayload;
import com.litongjava.tio.boot.admin.vo.GoogleToken;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.HttpUtils;
import com.litongjava.tio.utils.json.FastJson2Utils;
import com.litongjava.tio.utils.json.JsonUtils;
import com.litongjava.tio.utils.snowflake.SnowflakeIdUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class AppUserGoogleService {
    public RespBodyVo login(String code, String redirectUri) {
        String clientId = EnvUtils.get((String)"GOOGLE_CLIENT_ID");
        String clientSecret = EnvUtils.get((String)"GOOGLE_CLIENT_SECRET");
        String tokenUrl = "https://oauth2.googleapis.com/token";
        FormBody.Builder builder = new FormBody.Builder();
        builder.add("code", code).add("redirect_uri", redirectUri).add("grant_type", "authorization_code").add("client_id", clientId).add("client_secret", clientSecret);
        FormBody formBody = builder.build();
        Request request = new Request.Builder().url(tokenUrl).post((RequestBody)formBody).build();
        ResponseVo responseVo = HttpUtils.call((Request)request);
        if (responseVo.isOk()) {
            String tokenResponse = responseVo.getBodyString();
            GoogleJwtPayload googlePayload = this.parseGoogleId(tokenResponse);
            String googleId = googlePayload.getSub();
            Row row = Db.findFirst((String)"SELECT id FROM app_users WHERE google_id = ?", (Object[])new Object[]{googleId});
            String userId = null;
            String name = googlePayload.getName();
            String photo_url = googlePayload.getPicture();
            String email = googlePayload.getEmail();
            if (row == null) {
                Row emailRow = Db.findFirst((String)"SELECT id,email FROM app_users WHERE email = ?", (Object[])new Object[]{email});
                if (emailRow == null) {
                    long longId = SnowflakeIdUtils.id();
                    userId = String.valueOf(longId);
                    Row user = Row.by((String)"id", (Object)userId).set("email", (Object)email).set("display_name", (Object)name).set("photo_url", (Object)photo_url);
                    Db.save((String)"app_users", (Row)user);
                } else {
                    userId = emailRow.getString("id");
                }
            } else {
                userId = row.getString("id");
            }
            Long timeout = EnvUtils.getLong((String)"app.token.timeout", (Long)604800L);
            Long tokenTimeout = System.currentTimeMillis() / 1000L + timeout;
            AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);
            String token = appUserService.createToken(userId, tokenTimeout);
            String refreshToken = appUserService.createRefreshToken(userId);
            AppUserLoginVo appUserLoginVo = new AppUserLoginVo(userId, name, email, photo_url, refreshToken, token, tokenTimeout.intValue());
            return RespBodyVo.ok((Object)appUserLoginVo);
        }
        return RespBodyVo.fail((String)responseVo.getBodyString());
    }

    public GoogleJwtPayload parseGoogleId(String tokenResponse) {
        GoogleToken googleToken = (GoogleToken)FastJson2Utils.parse((String)tokenResponse, GoogleToken.class);
        String idToken = googleToken.getId_token();
        String[] tokenParts = idToken.split("\\.");
        if (tokenParts.length < 2) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684 id_token");
        }
        byte[] decodedBytes = Base64.getUrlDecoder().decode(tokenParts[1]);
        String payloadJsonStr = new String(decodedBytes, StandardCharsets.UTF_8);
        return (GoogleJwtPayload)JsonUtils.parse((String)payloadJsonStr, GoogleJwtPayload.class);
    }
}

