/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.mail;

import com.litongjava.tio.utils.environment.EnvUtils;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class LarkSuitMail {
    private Session session;
    private Transport transport;
    private Properties prop;
    private String mailHost = EnvUtils.get((String)"lark.mail.host");
    private Integer smtpPort;
    private String user;
    private String password;
    private String from;
    private String mailTransportProtocol = EnvUtils.get((String)"lark.mail.protocol");

    public LarkSuitMail() {
        this.smtpPort = EnvUtils.getInt((String)"lark.mail.smpt.port");
        this.user = EnvUtils.get((String)"lark.mail.user");
        this.password = EnvUtils.get((String)"lark.mail.password");
        this.from = EnvUtils.get((String)"lark.mail.from");
        this.prop = new Properties();
        this.prop.setProperty("mail.host", this.mailHost);
        this.prop.setProperty("mail.transport.protocol", this.mailTransportProtocol);
        this.prop.setProperty("mail.smtp.auth", "true");
        this.prop.setProperty("mail.smtp.port", this.smtpPort.toString());
        this.prop.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        this.prop.setProperty("mail.smtp.socketFactory.fallback", "false");
        this.prop.setProperty("mail.smtp.socketFactory.port", this.smtpPort.toString());
        this.session = Session.getInstance((Properties)this.prop);
        try {
            this.transport = this.session.getTransport();
            this.transport.connect(this.mailHost, this.smtpPort.intValue(), this.user, this.password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void send(String to, String subject, String content, boolean isDebug) {
        this.session.setDebug(isDebug);
        MimeMessage message = new MimeMessage(this.session);
        try {
            if (this.transport == null || !this.transport.isConnected()) {
                this.transport = this.session.getTransport();
                this.transport.connect(this.mailHost, this.smtpPort.intValue(), this.user, this.password);
            }
            message.setFrom((Address)new InternetAddress(this.from));
            message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            message.setSubject(subject);
            message.setText(content);
            this.transport.sendMessage((Message)message, message.getAllRecipients());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close() {
        if (this.transport != null && this.transport.isConnected()) {
            try {
                this.transport.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

