/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.handler;

import com.litongjava.jfinal.aop.Aop;
import com.litongjava.tio.boot.admin.services.DbRequestStatisticsService;
import com.litongjava.tio.boot.http.handler.internal.RequestStatisticsHandler;
import com.litongjava.tio.http.common.HttpMethod;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.common.utils.HttpIpUtils;
import com.litongjava.tio.utils.snowflake.SnowflakeIdUtils;
import com.litongjava.tio.utils.thread.TioThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbRequestStatisticsHandler
implements RequestStatisticsHandler {
    private static final Logger log = LoggerFactory.getLogger(DbRequestStatisticsHandler.class);
    DbRequestStatisticsService dbRequestStatisticsService = (DbRequestStatisticsService)Aop.get(DbRequestStatisticsService.class);

    public void count(HttpRequest request) {
        RequestLine requestLine = request.getRequestLine();
        HttpMethod method = requestLine.getMethod();
        String uri = requestLine.getPathAndQuery();
        long channel_id = Long.parseLong(request.getChannelContext().getId());
        String userAgent = request.getUserAgent();
        String authorization = request.getHeader("authorization");
        String token = request.getHeader("token");
        StringBuffer header = new StringBuffer();
        if (authorization != null) {
            header.append("authorization:").append(authorization).append("\n");
        }
        if (token != null) {
            header.append("token:").append(token).append("\n");
        }
        String bodyString = request.getBodyString();
        Object userId = request.getAttribute("userId");
        String clientIp = HttpIpUtils.getRealIp((HttpRequest)request);
        TioThreadUtils.submit(() -> {
            try {
                long id = SnowflakeIdUtils.id();
                this.dbRequestStatisticsService.saveDb(id, channel_id, clientIp, userId, method.toString(), uri, userAgent, header.toString(), bodyString);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

