/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.handler;

import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.model.validate.ValidateResult;
import com.litongjava.tio.boot.admin.services.AppEmailService;
import com.litongjava.tio.boot.admin.services.AppUserService;
import com.litongjava.tio.boot.admin.vo.AppUserRegisterRequest;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.Json;
import com.litongjava.tio.utils.validator.EmailValidator;
import com.litongjava.tio.utils.validator.PasswordValidator;
import java.util.ArrayList;

public class AppUserRegisterHandler {
    AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);

    public HttpResponse register(HttpRequest request) {
        ValidateResult validateResult;
        boolean exists;
        String password;
        ValidateResult validateResult2;
        String origin = request.getOrigin();
        HttpResponse response = TioRequestContext.getResponse();
        String body = request.getBodyString();
        AppUserRegisterRequest req = (AppUserRegisterRequest)Json.getJson().parse(body, AppUserRegisterRequest.class);
        ArrayList<ValidateResult> validateResults = new ArrayList<ValidateResult>();
        boolean ok = true;
        if (req.getVerification_type() != 0 && StrUtil.isEmpty((CharSequence)origin)) {
            ValidateResult validateResult3 = ValidateResult.by((String)"origin", (String)("Failed to valiate origin:" + origin));
            validateResults.add(validateResult3);
            ok = false;
        }
        boolean validate = false;
        String username = req.getUsername();
        String email = req.getEmail();
        if (username == null && email == null) {
            validateResult2 = ValidateResult.by((String)"username", (String)"Username and email cannot both be empty.");
            validateResults.add(validateResult2);
            ok = false;
        }
        if (email != null && !(validate = EmailValidator.validate((String)email))) {
            validateResult2 = ValidateResult.by((String)"email", (String)("Failed to valiate email:" + email));
            validateResults.add(validateResult2);
            ok = false;
        }
        if (!(validate = PasswordValidator.validate((String)(password = req.getPassword())))) {
            ValidateResult validateResult4 = ValidateResult.by((String)"password", (String)("Failed to valiate password:" + password));
            validateResults.add(validateResult4);
            ok = false;
        }
        if (!ok) {
            return response.setJson((Object)RespBodyVo.failData(validateResults));
        }
        if (email != null && (exists = this.appUserService.existsEmail(email))) {
            validateResult = ValidateResult.by((String)"email", (String)("email already taken" + email));
            validateResults.add(validateResult);
            ok = false;
        }
        if (username != null && (exists = this.appUserService.existsUsername(username))) {
            validateResult = ValidateResult.by((String)"email", (String)("username already taken" + email));
            validateResults.add(validateResult);
            ok = false;
        }
        if (!ok) {
            return response.setJson((Object)RespBodyVo.failData(validateResults));
        }
        boolean success = false;
        Long userId = req.getUserId();
        success = userId != null && this.appUserService.exists(userId.toString()) ? this.appUserService.registerUserByUserId(req, origin) : this.appUserService.registerUser(req.getEmail(), req.getUsername(), req.getPassword(), req.getUserType(), origin);
        if (success) {
            if (req.getVerification_type() == 1) {
                AppEmailService emailService = (AppEmailService)Aop.get(AppEmailService.class);
                boolean sent = emailService.sendVerificationCodeEmail(req.getEmail(), origin);
                if (sent) {
                    return response.setJson((Object)RespBodyVo.ok());
                }
                return response.setJson((Object)RespBodyVo.fail((String)"Failed to send email"));
            }
            if (req.getVerification_type() == 2) {
                AppEmailService emailService = (AppEmailService)Aop.get(AppEmailService.class);
                boolean sent = emailService.sendVerificationEmail(req.getEmail(), origin);
                if (sent) {
                    return response.setJson((Object)RespBodyVo.ok());
                }
                return response.setJson((Object)RespBodyVo.fail((String)"Failed to send email"));
            }
            return response.setJson((Object)RespBodyVo.ok());
        }
        return response.setJson((Object)RespBodyVo.fail());
    }
}

