/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.handler;

import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.tio.boot.admin.services.AppUserService;
import com.litongjava.tio.boot.admin.vo.AppUser;
import com.litongjava.tio.boot.admin.vo.AppUserLoginRequest;
import com.litongjava.tio.boot.admin.vo.AppUserLoginVo;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.json.JsonUtils;

public class AppUserLoginHandler {
    public HttpResponse login(HttpRequest request) {
        HttpResponse response = TioRequestContext.getResponse();
        String body = request.getBodyString();
        AppUserLoginRequest req = (AppUserLoginRequest)JsonUtils.parse((String)body, AppUserLoginRequest.class);
        AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);
        String username = req.getUsername();
        String email = req.getEmail();
        if (username == null && email == null) {
            return response.setJson((Object)RespBodyVo.fail((String)"username and password cannot both be empty"));
        }
        AppUser user = null;
        if (username != null) {
            user = appUserService.getUserByUsername(username);
        } else if (email != null) {
            user = appUserService.getUserByEmail(email);
        }
        if (user != null && appUserService.verifyPassword(user, req.getPassword())) {
            Long timeout = EnvUtils.getLong((String)"app.token.timeout", (Long)604800L);
            Long tokenTimeout = System.currentTimeMillis() / 1000L + timeout;
            String userId = user.getId();
            String token = appUserService.createToken(userId, tokenTimeout);
            String refreshToken = appUserService.createRefreshToken(userId);
            AppUserLoginVo appUserLoginVo = new AppUserLoginVo(userId, user.getDisplayName(), email, refreshToken, token, tokenTimeout.intValue());
            return response.setJson((Object)RespBodyVo.ok((Object)appUserLoginVo));
        }
        return response.setJson((Object)RespBodyVo.fail((String)"username or password is not correct"));
    }

    public HttpResponse logout(HttpRequest request) {
        HttpResponse response = TioRequestContext.getResponse();
        String userId = TioRequestContext.getUserIdString();
        AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);
        boolean logout = appUserService.logout(userId);
        if (logout) {
            response.setJson((Object)RespBodyVo.ok());
        } else {
            response.setJson((Object)RespBodyVo.fail());
        }
        return response;
    }
}

