/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.handler;

import com.jfinal.kit.Kv;
import com.litongjava.db.activerecord.Row;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.tio.boot.admin.services.AppUserService;
import com.litongjava.tio.boot.admin.vo.AppUser;
import com.litongjava.tio.boot.admin.vo.UserResetPasswordRequest;
import com.litongjava.tio.boot.admin.vo.UserUpdatePasswordRequest;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.json.FastJson2Utils;
import com.litongjava.tio.utils.json.JsonUtils;
import com.litongjava.tio.utils.jwt.JwtUtils;
import java.util.Map;

public class AppUserHandler {
    public HttpResponse refresh(HttpRequest request) {
        HttpResponse response = TioRequestContext.getResponse();
        String bodyString = request.getBodyString();
        String refresh_token = FastJson2Utils.parseObject((String)bodyString).getString("refresh_token");
        String key = EnvUtils.getStr((String)"admin.secret.key");
        boolean verify = JwtUtils.verify((String)key, (String)refresh_token);
        if (verify) {
            String userId = JwtUtils.parseUserIdString((String)refresh_token);
            AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);
            Long timeout = EnvUtils.getLong((String)"app.token.timeout", (Long)604800L);
            Long tokenTimeout = System.currentTimeMillis() / 1000L + timeout;
            String token = appUserService.createToken(userId, tokenTimeout);
            Kv kv = Kv.by((Object)"user_id", (Object)userId).set((Object)"token", (Object)token).set((Object)"expires_in", (Object)tokenTimeout.intValue());
            response.setJson((Object)RespBodyVo.ok((Object)kv));
        } else {
            response.setJson((Object)RespBodyVo.fail((String)"Failed to validate refresh_token"));
        }
        return response;
    }

    public HttpResponse remove(HttpRequest request) {
        HttpResponse response = TioRequestContext.getResponse();
        String userIdString = TioRequestContext.getUserIdString();
        AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);
        boolean ok = appUserService.remove(userIdString);
        if (ok) {
            response.setJson((Object)RespBodyVo.ok());
        } else {
            response.setJson((Object)RespBodyVo.fail());
        }
        return response;
    }

    public HttpResponse resetPassword(HttpRequest request) {
        HttpResponse response = TioRequestContext.getResponse();
        String bodyString = request.getBodyString();
        UserResetPasswordRequest userResetPassword = (UserResetPasswordRequest)JsonUtils.parse((String)bodyString, UserResetPasswordRequest.class);
        AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);
        RespBodyVo vo = appUserService.resetPassword(userResetPassword);
        return response.setJson((Object)vo);
    }

    public HttpResponse profile(HttpRequest request) {
        String userIdString = TioRequestContext.getUserIdString();
        AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);
        AppUser user = appUserService.getUserById(userIdString);
        HttpResponse response = TioRequestContext.getResponse();
        return response.body((Object)RespBodyVo.ok((Object)user));
    }

    public HttpResponse update(HttpRequest request) {
        String userIdString = TioRequestContext.getUserIdString();
        String bodyString = request.getBodyString();
        Map requestMap = FastJson2Utils.parseToMap((String)bodyString, String.class, Object.class);
        requestMap.remove("password_salt");
        requestMap.remove("password_hash");
        Row row = Row.fromMap((Map)requestMap);
        AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);
        HttpResponse response = TioRequestContext.getResponse();
        return response.body((Object)RespBodyVo.ok((Object)appUserService.updateById(userIdString, row)));
    }

    public HttpResponse updatePassword(HttpRequest request) {
        String userIdString = TioRequestContext.getUserIdString();
        String bodyString = request.getBodyString();
        UserUpdatePasswordRequest updatePasswordRequest = (UserUpdatePasswordRequest)FastJson2Utils.parse((String)bodyString, UserUpdatePasswordRequest.class);
        AppUserService appUserService = (AppUserService)Aop.get(AppUserService.class);
        HttpResponse response = TioRequestContext.getResponse();
        RespBodyVo respBodyvo = appUserService.updatePassword(userIdString, updatePasswordRequest);
        return response.body((Object)respBodyvo);
    }
}

