/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.handler;

import com.jfinal.kit.Kv;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.model.token.AuthToken;
import com.litongjava.tio.boot.admin.services.LoginService;
import com.litongjava.tio.boot.admin.vo.LoginAccountVo;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.server.model.HttpCors;
import com.litongjava.tio.http.server.util.CORSUtils;
import com.litongjava.tio.http.server.util.Resps;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.json.Json;
import com.litongjava.tio.utils.jwt.JwtUtils;
import com.litongjava.tio.utils.token.TokenManager;
import java.util.HashMap;

public class AdminLoginHandler {
    public HttpResponse account(HttpRequest request) {
        RespBodyVo respVo;
        HttpResponse httpResponse = TioRequestContext.getResponse();
        CORSUtils.enableCORS((HttpResponse)httpResponse, (HttpCors)new HttpCors());
        String bodyString = request.getBodyString();
        LoginAccountVo loginAccountVo = (LoginAccountVo)Json.getJson().parse(bodyString, LoginAccountVo.class);
        LoginService loginService = (LoginService)Aop.get(LoginService.class);
        Long userId = loginService.getUserIdByUsernameAndPassword(loginAccountVo);
        if (userId != null) {
            long tokenTimeout = (System.currentTimeMillis() + 604800000L) / 1000L;
            String keyValue = EnvUtils.getStr((String)"admin.secret.key");
            AuthToken authToken = JwtUtils.createToken((String)keyValue, (AuthToken)new AuthToken((Object)userId.toString(), tokenTimeout));
            TokenManager.login((Object)userId, (String)authToken.getToken());
            Kv kv = new Kv();
            kv.set((Object)"userId", (Object)userId);
            kv.set((Object)"token", (Object)authToken.getToken());
            kv.set((Object)"tokenTimeout", (Object)tokenTimeout);
            kv.set((Object)"type", (Object)loginAccountVo.getType());
            kv.set((Object)"status", (Object)"ok");
            respVo = RespBodyVo.ok((Object)kv);
        } else {
            HashMap<String, String> data = new HashMap<String, String>(1);
            data.put("status", "false");
            respVo = RespBodyVo.fail().data(data);
        }
        return Resps.json((HttpResponse)httpResponse, (Object)respVo);
    }

    public HttpResponse outLogin(HttpRequest request) {
        HttpResponse httpResponse = TioRequestContext.getResponse();
        CORSUtils.enableCORS((HttpResponse)httpResponse, (HttpCors)new HttpCors());
        Long userIdLong = TioRequestContext.getUserIdLong();
        TokenManager.logout((Object)userIdLong);
        return Resps.json((HttpResponse)httpResponse, (Object)RespBodyVo.ok());
    }

    public HttpResponse validateLogin(HttpRequest request) {
        HttpResponse httpResponse = TioRequestContext.getResponse();
        CORSUtils.enableCORS((HttpResponse)httpResponse, (HttpCors)new HttpCors());
        Long userIdLong = TioRequestContext.getUserIdLong();
        boolean login = TokenManager.isLogin((Object)userIdLong);
        return Resps.json((HttpResponse)httpResponse, (Object)RespBodyVo.ok((Object)login));
    }

    public HttpResponse validateToken(HttpRequest request) {
        HttpResponse httpResponse = TioRequestContext.getResponse();
        CORSUtils.enableCORS((HttpResponse)httpResponse, (HttpCors)new HttpCors());
        Long userIdLong = TioRequestContext.getUserIdLong();
        return Resps.txt((HttpResponse)httpResponse, (String)userIdLong.toString());
    }
}

