/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.dao;

import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SystemUploadFileDao {
    public static final String tableName = "tio_boot_admin_system_upload_file";
    public static final String getFileBasicInfoByMd5Sql = String.format("select id,name,size,bucket_name,target_name from %s  where md5=? and deleted=0", "tio_boot_admin_system_upload_file");
    public static final String getFileBasicInfoByIdSql = String.format("select md5,name,size,bucket_name,target_name from %s where id=? and deleted=0", "tio_boot_admin_system_upload_file");

    public Row getFileBasicInfoByMd5(String md5) {
        return Db.findFirst((String)getFileBasicInfoByMd5Sql, (Object[])new Object[]{md5});
    }

    public Row getFileBasicInfoById(long id) {
        return Db.findFirst((String)getFileBasicInfoByIdSql, (Object[])new Object[]{id});
    }

    public List<Row> getFileBasicInfoByIds(List<Long> file_ids) {
        if (file_ids == null || file_ids.isEmpty()) {
            return new ArrayList<Row>();
        }
        String placeholders = file_ids.stream().map(id -> "?").collect(Collectors.joining(","));
        String sql = String.format("select id,md5,name,size,bucket_name,target_name from %s where id in (%s) and deleted=0", tableName, placeholders);
        return Db.find((String)sql, (Object[])file_ids.toArray());
    }

    public boolean save(long id, String md5, String originname, int fileSize, String platform, String bucketName, String targetName) {
        Row record = Row.by((String)"id", (Object)id).set("md5", (Object)md5).set("name", (Object)originname).set("size", (Object)fileSize).set("platform", (Object)platform).set("bucket_name", (Object)bucketName).set("target_name", (Object)targetName);
        return Db.save((String)tableName, (Row)record);
    }
}

