/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.controller;

import com.jfinal.kit.Kv;
import com.litongjava.annotation.EnableCORS;
import com.litongjava.annotation.RequestPath;
import com.litongjava.db.TableInput;
import com.litongjava.db.TableResult;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.model.page.DbPage;
import com.litongjava.table.utils.EasyExcelResponseUtils;
import com.litongjava.table.utils.TableInputUtils;
import com.litongjava.tio.boot.admin.services.MongodbJsonService;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.boot.utils.TioRequestParamUtils;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestPath(value="/mongodb/json")
@EnableCORS
public class MongodbController {
    private static final Logger log = LoggerFactory.getLogger(MongodbController.class);
    private MongodbJsonService mongodbJsonService = (MongodbJsonService)Aop.get(MongodbJsonService.class);

    @RequestPath(value="/{f}/page")
    public RespBodyVo page(String f, HttpRequest request) {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        Object current = map.remove("current");
        if (current != null) {
            map.put("pageNo", current);
        }
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        TableResult<DbPage<Document>> dbJsonBean = this.mongodbJsonService.page(f, kv);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/export-excel")
    public HttpResponse exportExcel(String f, HttpRequest request) throws IOException {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        Object current = map.remove("current");
        if (current != null) {
            map.put("pageNo", current);
        }
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        String filename = f + "_export_" + System.currentTimeMillis() + ".xlsx";
        List records = (List)this.mongodbJsonService.list(f, kv).getData();
        log.info("records:{}", (Object)records);
        HttpResponse response = TioRequestContext.getResponse();
        return EasyExcelResponseUtils.exportRecords((HttpResponse)response, (String)filename, (String)f, (List)records);
    }

    @RequestPath(value="/{f}/export-table-excel")
    public HttpResponse exportAllExcel(String f, HttpRequest request) throws IOException, SQLException {
        log.info("tableName:{}", (Object)f);
        String filename = f + "-all_" + System.currentTimeMillis() + ".xlsx";
        List records = (List)this.mongodbJsonService.listAll(f).getData();
        HttpResponse response = TioRequestContext.getResponse();
        EasyExcelResponseUtils.exportRecords((HttpResponse)response, (String)filename, (String)f, (List)records);
        log.info("finished");
        return response;
    }

    @RequestPath(value="/{f}/create")
    public RespBodyVo create(String f, HttpRequest request) {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        TableResult<Kv> dbJsonBean = this.mongodbJsonService.saveOrUpdate(f, kv);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/delete/{id}")
    public RespBodyVo delete(String f, String id) {
        log.info("tableName:{},id:{}", (Object)f, (Object)id);
        TableResult<Boolean> dbJsonBean = this.mongodbJsonService.deleteById(f, id);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }
}

