/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.controller;

import com.litongjava.annotation.EnableCORS;
import com.litongjava.annotation.RequestPath;
import com.litongjava.db.TableInput;
import com.litongjava.db.TableResult;
import com.litongjava.db.activerecord.Db;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.model.page.Page;
import com.litongjava.table.services.ApiTable;
import com.litongjava.table.utils.EasyExcelResponseUtils;
import com.litongjava.table.utils.TableInputUtils;
import com.litongjava.table.utils.TableResultUtils;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.boot.utils.TioRequestParamUtils;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestPath(value="/api/table")
@EnableCORS
public class ApiTableController {
    private static final Logger log = LoggerFactory.getLogger(ApiTableController.class);

    @RequestPath(value="/index")
    public String index() {
        return "TableJsonController";
    }

    @RequestPath(value="/{f}/create")
    public RespBodyVo create(String f, HttpRequest request) {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        ApiTable.transformType((String)f, (Map)map);
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        TableResult dbJsonBean = ApiTable.saveOrUpdate((String)f, (TableInput)kv);
        if (dbJsonBean.getCode() == 1) {
            return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
        }
        return RespBodyVo.fail((String)dbJsonBean.getMsg()).code(Integer.valueOf(dbJsonBean.getCode())).data(dbJsonBean.getData());
    }

    @RequestPath(value="/{f}/list")
    public RespBodyVo list(String f, HttpRequest request) {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        ApiTable.transformType((String)f, (Map)map);
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        TableResult list = ApiTable.list((String)f, (TableInput)kv);
        TableResult dbJsonBean = TableResultUtils.recordsToKv((TableResult)list, (boolean)false);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/listAll")
    public RespBodyVo listAll(String f) {
        log.info("tableName:{}", (Object)f);
        TableResult listAll = ApiTable.listAll((String)f);
        TableResult dbJsonBean = TableResultUtils.recordsToKv((TableResult)listAll, (boolean)false);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/page")
    public RespBodyVo page(String f, HttpRequest request) {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        Object current = map.remove("current");
        if (current != null) {
            map.put("pageNo", current);
        }
        ApiTable.transformType((String)f, (Map)map);
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        TableResult page = ApiTable.page((String)f, (TableInput)kv);
        TableResult dbJsonBean = TableResultUtils.pageToDbPage((TableResult)page, (boolean)false);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/get")
    public RespBodyVo get(String f, HttpRequest request) {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        ApiTable.transformType((String)f, (Map)map);
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        TableResult jsonBean = ApiTable.get((String)f, (TableInput)kv);
        TableResult dbJsonBean = TableResultUtils.recordToKv((TableResult)jsonBean);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/update")
    public RespBodyVo update(String f, HttpRequest request) {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        ApiTable.transformType((String)f, (Map)map);
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        TableResult dbJsonBean = ApiTable.saveOrUpdate((String)f, (TableInput)kv);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/batchUpdate")
    public RespBodyVo batchUpdate(String f, HttpRequest request) {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        ApiTable.transformType((String)f, (Map)map);
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        TableResult dbJsonBean = ApiTable.batchUpdateByIds((String)f, (TableInput)kv);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/remove/{id}")
    public RespBodyVo remove(String f, String id) {
        log.info("tableName:{},id:{}", (Object)f, (Object)id);
        TableResult dbJsonBean = ApiTable.updateFlagById((String)f, (Object)id, (String)"deleted", (int)1);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/delete/{id}")
    public RespBodyVo delete(String f, String id) {
        log.info("tableName:{},id:{}", (Object)f, (Object)id);
        TableResult dbJsonBean = ApiTable.delById((String)f, (Object)id);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/total")
    public RespBodyVo total(String f) {
        log.info("tableName:{},id:{}", (Object)f);
        Long count = Db.count((String)f);
        return RespBodyVo.ok((Object)count);
    }

    @RequestPath(value="/{f}/export-current")
    public HttpResponse exportCurrent(String f, HttpRequest request) throws IOException {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        ApiTable.transformType((String)f, (Map)map);
        Object current = map.remove("current");
        if (current != null) {
            map.put("pageNo", current);
        }
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        String filename = f + "_export-current-page" + System.currentTimeMillis() + ".xlsx";
        TableResult result = ApiTable.page((String)f, (TableInput)kv);
        List records = ((Page)result.getData()).getList();
        HttpResponse response = TioRequestContext.getResponse();
        EasyExcelResponseUtils.exportRecords((HttpResponse)response, (String)filename, (String)f, (List)records);
        log.info("finished {}", (Object)filename);
        return response;
    }

    @RequestPath(value="/{f}/export-all")
    public HttpResponse exportAllExcel(String f, HttpRequest request) throws IOException, SQLException {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        map.remove("current");
        map.remove("pageNo");
        map.remove("pageSize");
        ApiTable.transformType((String)f, (Map)map);
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        String filename = f + "-all_" + System.currentTimeMillis() + ".xlsx";
        TableResult result = ApiTable.list((String)f, (TableInput)kv);
        List records = (List)result.getData();
        HttpResponse response = TioRequestContext.getResponse();
        EasyExcelResponseUtils.exportRecords((HttpResponse)response, (String)filename, (String)f, (List)records);
        log.info("finished {}", (Object)filename);
        return response;
    }

    @RequestPath(value="/export-all-table-excel")
    public HttpResponse exportAllTableExcel(HttpRequest request) throws IOException {
        String filename = "all-table_" + System.currentTimeMillis() + ".xlsx";
        String[] tables = ApiTable.getAllTableNames();
        LinkedHashMap<String, List> allTableData = new LinkedHashMap<String, List>();
        for (String table : tables) {
            List records = (List)ApiTable.listAll((String)table).getData();
            allTableData.put(table, records);
        }
        HttpResponse response = TioRequestContext.getResponse();
        EasyExcelResponseUtils.exportAllTableRecords((HttpResponse)response, (String)filename, allTableData);
        log.info("finished");
        return response;
    }

    @RequestPath(value="/{f}/pageDeleted")
    public RespBodyVo pageDeleted(String f, HttpRequest request) {
        Map map = TioRequestParamUtils.getRequestMap((HttpRequest)request);
        map.remove("f");
        ApiTable.transformType((String)f, (Map)map);
        TableInput kv = TableInputUtils.camelToUnderscore((Map)map);
        log.info("tableName:{},kv:{}", (Object)f, (Object)kv);
        TableResult dbJsonBean = TableResultUtils.pageToDbPage((TableResult)ApiTable.page((String)f, (TableInput)kv), (boolean)false);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/recover")
    public RespBodyVo recover(String f, String id) {
        log.info("tableName:{},id:{}", (Object)f, (Object)id);
        TableResult dbJsonBean = ApiTable.updateFlagById((String)f, (Object)id, (String)"deleted", (int)0);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/names")
    public RespBodyVo tableNames() throws IOException {
        String[] data = (String[])ApiTable.tableNames().getData();
        return RespBodyVo.ok((Object)data);
    }

    @RequestPath(value="/{f}/config")
    public RespBodyVo fConfig(String f, String lang) {
        log.info("tableName:{}", (Object)f);
        TableResult dbJsonBean = ApiTable.tableConfig((String)f, (String)f, (String)lang);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }

    @RequestPath(value="/{f}/columns")
    public RespBodyVo proTableColumns(String f) {
        TableResult dbJsonBean = ApiTable.columns((String)f);
        return RespBodyVo.ok((Object)dbJsonBean.getData()).code(Integer.valueOf(dbJsonBean.getCode())).msg(dbJsonBean.getMsg());
    }
}

