/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.config;

import com.litongjava.hook.HookCan;
import com.litongjava.redis.Redis;
import com.litongjava.redis.RedisDb;
import com.litongjava.redis.RedisPlugin;
import com.litongjava.tio.utils.environment.EnvUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioAdminRedisDbConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TioAdminRedisDbConfiguration.class);

    public void config() {
        String host = EnvUtils.getStr((String)"redis.host");
        if (host == null) {
            return;
        }
        log.info("host:{}", (Object)host);
        Integer port = EnvUtils.getInt((String)"redis.port");
        String password = EnvUtils.getStr((String)"redis.password");
        int redisTimeout = EnvUtils.getInt((String)"redis.timeout", (int)60);
        int redisDatabase = EnvUtils.getInt((String)"redis.database", (int)0);
        String cacheName = EnvUtils.get((String)"redis.cacheName", (String)"main");
        RedisPlugin mainRedis = new RedisPlugin(cacheName, host, port.intValue(), redisTimeout, password, redisDatabase);
        mainRedis.start();
        RedisDb cache = Redis.use((String)cacheName);
        try {
            cache.getJedis().connect();
        }
        catch (Exception e) {
            log.error("failed to connected to {},{},{}", new Object[]{host, port, password});
            e.printStackTrace();
        }
        HookCan.me().addDestroyMethod(() -> ((RedisPlugin)mainRedis).stop());
    }
}

