/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.config;

import com.litongjava.hook.HookCan;
import com.litongjava.mongo.MongoDb;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioAdminMongoDbConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TioAdminMongoDbConfiguration.class);

    public void config() {
        String mongodbHost = EnvUtils.getStr((String)"mongodb.host");
        if (mongodbHost == null) {
            return;
        }
        int mongodbPort = EnvUtils.getInt((String)"mongodb.port");
        String mongodbAuthSource = EnvUtils.get((String)"mongodb.authSource");
        String mongodbUsername = EnvUtils.get((String)"mongodb.username");
        String mongodbPassword = EnvUtils.get((String)"mongodb.password");
        String mongodbDatabase = EnvUtils.get((String)"mongodb.database");
        log.info("mongo:{}:{},{}", new Object[]{mongodbHost, mongodbPort, mongodbDatabase});
        ArrayList<ServerAddress> adds = new ArrayList<ServerAddress>();
        ServerAddress serverAddress = new ServerAddress(mongodbHost, mongodbPort);
        adds.add(serverAddress);
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        MongoCredential mongoCredential = MongoCredential.createScramSha1Credential((String)mongodbUsername, (String)mongodbAuthSource, (char[])mongodbPassword.toCharArray());
        credentials.add(mongoCredential);
        MongoClient mongoClient = new MongoClient(adds, credentials);
        MongoDatabase mongoDatabase = mongoClient.getDatabase(mongodbDatabase);
        MongoDb.setClient((MongoClient)mongoClient);
        MongoDb.setDatabase((MongoDatabase)mongoDatabase);
        HookCan.me().addDestroyMethod(() -> ((MongoClient)mongoClient).close());
    }
}

