/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.config;

import com.litongjava.tio.boot.admin.costants.TioBootAdminUrls;
import com.litongjava.tio.boot.admin.services.TioBootAdminTokenPredicate;
import com.litongjava.tio.boot.http.interceptor.HttpInteceptorConfigure;
import com.litongjava.tio.boot.http.interceptor.HttpInterceptorModel;
import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.boot.token.AuthTokenInterceptor;
import com.litongjava.tio.http.server.intf.HttpRequestInterceptor;
import java.util.function.Predicate;

public class TioAdminInterceptorConfiguration {
    private String[] permitUrls;
    private boolean alloweStaticFile;
    private Predicate<String> validateTokenLogic;

    public TioAdminInterceptorConfiguration() {
    }

    public TioAdminInterceptorConfiguration(String[] permitUrls) {
        this.permitUrls = permitUrls;
    }

    public TioAdminInterceptorConfiguration(String[] permitUrls, Predicate<String> validateTokenLogic) {
        this.permitUrls = permitUrls;
        this.validateTokenLogic = validateTokenLogic;
    }

    public TioAdminInterceptorConfiguration(String[] permitUrls, boolean b) {
        this.permitUrls = permitUrls;
        this.alloweStaticFile = b;
    }

    public void config() {
        if (this.validateTokenLogic == null) {
            this.validateTokenLogic = new TioBootAdminTokenPredicate();
        }
        AuthTokenInterceptor authTokenInterceptor = new AuthTokenInterceptor(this.validateTokenLogic);
        HttpInterceptorModel model = new HttpInterceptorModel();
        model.setInterceptor((HttpRequestInterceptor)authTokenInterceptor);
        model.addBlockUrl("/**");
        model.addAllowUrls(TioBootAdminUrls.ALLLOW_URLS);
        if (this.permitUrls != null) {
            model.addAllowUrls(this.permitUrls);
        }
        model.setAlloweStaticFile(this.alloweStaticFile);
        HttpInteceptorConfigure inteceptorConfigure = new HttpInteceptorConfigure();
        inteceptorConfigure.add(model);
        TioBootServer.me().setHttpInteceptorConfigure(inteceptorConfigure);
    }
}

