/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.config;

import com.litongjava.db.activerecord.ActiveRecordPlugin;
import com.litongjava.db.activerecord.IContainerFactory;
import com.litongjava.db.activerecord.OrderedFieldContainerFactory;
import com.litongjava.db.activerecord.dialect.Dialect;
import com.litongjava.db.activerecord.dialect.PostgreSqlDialect;
import com.litongjava.db.activerecord.dialect.Sqlite3Dialect;
import com.litongjava.db.hikaricp.DsContainer;
import com.litongjava.hook.HookCan;
import com.litongjava.openai.client.OpenAiClient;
import com.litongjava.table.services.ApiTable;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioAdminDbConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TioAdminDbConfiguration.class);

    public void config() {
        String jdbcUrl = EnvUtils.get((String)"jdbc.url");
        if (jdbcUrl == null) {
            return;
        }
        log.info("jdbcUrl:{}", (Object)jdbcUrl);
        try {
            String dbPath;
            Path path;
            if (jdbcUrl != null && jdbcUrl.startsWith("jdbc:sqlite:") && (path = Paths.get(dbPath = jdbcUrl.substring("jdbc:sqlite:".length()), new String[0]).getParent()) != null && !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
                log.info("\u5df2\u521b\u5efa SQLite \u6570\u636e\u5e93\u76ee\u5f55: {}", (Object)path);
            }
        }
        catch (IOException e) {
            log.error("\u521b\u5efa SQLite \u6570\u636e\u5e93\u76ee\u5f55\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        String jdbcUser = EnvUtils.get((String)"jdbc.user");
        String jdbcPswd = EnvUtils.get((String)"jdbc.pswd");
        int maximumPoolSize = EnvUtils.getInt((String)"jdbc.MaximumPoolSize", (int)2);
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(jdbcUrl);
        config.setUsername(jdbcUser);
        config.setPassword(jdbcPswd);
        config.setMaximumPoolSize(maximumPoolSize);
        HikariDataSource hikariDataSource = new HikariDataSource(config);
        DsContainer.setDataSource((DataSource)hikariDataSource);
        HookCan.me().addDestroyMethod(() -> ((HikariDataSource)hikariDataSource).close());
        ActiveRecordPlugin arp = new ActiveRecordPlugin((DataSource)hikariDataSource);
        arp.setContainerFactory((IContainerFactory)new OrderedFieldContainerFactory());
        boolean showSql = EnvUtils.getBoolean((String)"jdbc.showSql", (boolean)false);
        arp.setShowSql(showSql);
        if (EnvUtils.isDev()) {
            arp.setDevMode(true);
        }
        if (jdbcUrl.contains("jdbc:postgresql")) {
            arp.setDialect((Dialect)new PostgreSqlDialect());
        } else if (jdbcUrl.startsWith("jdbc:sqlite")) {
            arp.setDialect((Dialect)new Sqlite3Dialect());
        }
        arp.start();
        ApiTable.setEmbeddingFun(string -> {
            float[] embeddingArray = OpenAiClient.embeddingArray((String)string);
            return Arrays.toString(embeddingArray);
        });
        HookCan.me().addDestroyMethod(() -> ((ActiveRecordPlugin)arp).stop());
    }
}

