/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.client;

import com.litongjava.jfinal.aop.Aop;
import com.litongjava.tio.http.common.UploadFile;
import com.litongjava.tio.utils.environment.EnvUtils;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class StableDiffusionClient {
    public static final String generateSd3ServerUrl = "https://api.stability.ai/v2beta/stable-image/generate/sd3";

    public Response generateSd3(UploadFile uploadFile, Map<String, Object> requestMap) {
        String apiKey = EnvUtils.get((String)"SD_API_KEY");
        OkHttpClient client = (OkHttpClient)Aop.get(OkHttpClient.class);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> e : requestMap.entrySet()) {
            builder.addFormDataPart(e.getKey(), (String)e.getValue());
        }
        String strMode = (String)requestMap.get("mode");
        if ("image-to-image".equals(strMode)) {
            RequestBody fileBody = RequestBody.create((byte[])uploadFile.getData(), (MediaType)MediaType.parse((String)"image/png"));
            String filename = uploadFile.getName();
            builder.addFormDataPart("image", filename, fileBody);
        }
        MultipartBody body = builder.build();
        Request request = new Request.Builder().url(generateSd3ServerUrl).method("POST", (RequestBody)body).addHeader("authorization", "Bearer " + apiKey).addHeader("accept", "image/*").addHeader("Content-Type", "multipart/form-data").build();
        try {
            return client.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

