/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.aop.scanner;

import com.litongjava.annotation.AComponentScan;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentScanner {
    private static final Logger log = LoggerFactory.getLogger(DefaultComponentScanner.class);

    public List<Class<?>> scan(Class<?>[] primarySources, boolean printScannedClasses) throws Exception {
        ArrayList classes = new ArrayList();
        ArrayList<AComponentScan.Filter> allExcludeFilters = new ArrayList<AComponentScan.Filter>();
        ArrayList<String> allBasePackages = new ArrayList<String>();
        for (Class<?> primarySource : primarySources) {
            AComponentScan componentScan = primarySource.getAnnotation(AComponentScan.class);
            if (componentScan == null) continue;
            for (AComponentScan.Filter filter : componentScan.excludeFilters()) {
                allExcludeFilters.add(filter);
            }
            String[] basePackages = componentScan.value();
            if (basePackages == null || basePackages.length == 0 || basePackages.length == 1 && basePackages[0].isEmpty()) {
                basePackages = new String[]{primarySource.getPackage().getName()};
            }
            for (String basePackage : basePackages) {
                allBasePackages.add(basePackage);
            }
        }
        for (String basePackage : allBasePackages) {
            classes.addAll(this.findClasses(basePackage, allExcludeFilters.toArray(new AComponentScan.Filter[0]), printScannedClasses));
        }
        return classes;
    }

    private List<Class<?>> findClasses(String basePackage, AComponentScan.Filter[] excludeFilters, boolean printScannedClasses) throws Exception {
        ArrayList classes = new ArrayList();
        String path = basePackage.replace('.', '/');
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = contextClassLoader.getResources(path);
        ArrayList<URL> findedResource = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (findedResource.contains(resource)) continue;
            findedResource.add(resource);
            URLConnection connection = resource.openConnection();
            log.info("resource:{}", (Object)resource);
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)connection;
                JarFile jarFile = jarConnection.getJarFile();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(path) || !entryName.endsWith(".class")) continue;
                    String className = entryName.replace('/', '.').substring(0, entryName.length() - 6);
                    Class<?> clazz = contextClassLoader.loadClass(className);
                    classes.add(clazz);
                }
                continue;
            }
            File classRootDirctory = new File(resource.getFile());
            LinkedList<File> directories = new LinkedList<File>();
            directories.add(classRootDirctory);
            while (!directories.isEmpty()) {
                File currentDirectory = (File)directories.poll();
                for (File file : currentDirectory.listFiles()) {
                    if (file.isDirectory()) {
                        directories.add(file);
                        continue;
                    }
                    if (!file.getName().endsWith(".class")) continue;
                    if (printScannedClasses) {
                        log.info("class:{}", (Object)file.getName());
                    }
                    String className = file.getName().substring(0, file.getName().length() - 6);
                    String classFullName = null;
                    if (currentDirectory != classRootDirctory) {
                        String relativePath = currentDirectory.getAbsolutePath().substring(classRootDirctory.getAbsolutePath().length() + 1).replace(File.separatorChar, '.');
                        classFullName = basePackage + '.' + relativePath + '.' + className;
                    } else {
                        classFullName = basePackage + '.' + className;
                    }
                    try {
                        Class<?> clazz = contextClassLoader.loadClass(classFullName);
                        classes.add(clazz);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.applyExcludeFilters(classes, excludeFilters);
    }

    private List<Class<?>> applyExcludeFilters(List<Class<?>> classes, AComponentScan.Filter[] excludeFilters) {
        if (excludeFilters == null || excludeFilters.length == 0) {
            return classes;
        }
        ArrayList filteredClasses = new ArrayList(classes);
        block6: for (AComponentScan.Filter filter : excludeFilters) {
            switch (filter.type()) {
                case ASSIGNABLE_TYPE: {
                    for (Class excludeClass : filter.value()) {
                        filteredClasses.removeIf(clazz -> clazz.equals(excludeClass));
                    }
                    continue block6;
                }
                case ANNOTATION: {
                    Class annotation = filter.value()[0];
                    filteredClasses.removeIf(clazz -> clazz.isAnnotationPresent(annotation));
                    continue block6;
                }
                case REGEX: {
                    for (String regex : filter.pattern()) {
                        Pattern pattern = Pattern.compile(regex);
                        filteredClasses.removeIf(clazz -> pattern.matcher(clazz.getName()).matches());
                    }
                    continue block6;
                }
                case CUSTOM: {
                    continue block6;
                }
            }
        }
        return filteredClasses;
    }
}

