/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.aop.process;

import com.litongjava.annotation.ABean;
import com.litongjava.annotation.Initialization;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.jfinal.aop.AopManager;
import com.litongjava.jfinal.model.DestroyableBean;
import com.litongjava.model.result.MultiResult;
import com.litongjava.model.result.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAnnotaionProcess {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationAnnotaionProcess.class);

    public MultiResult<Queue<Object>, List<DestroyableBean>, Void> processConfiguration(Queue<Class<?>> configurationClass, Map<Class<Object>, Class<? extends Object>> mapping) {
        if (configurationClass == null || configurationClass.size() < 1) {
            return null;
        }
        ArrayList<Pair> beanMethods = new ArrayList<Pair>();
        ArrayList<Pair> initializationMethods = new ArrayList<Pair>();
        for (Class clazz : configurationClass) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(ABean.class)) {
                    beanMethods.add(new Pair((Object)method, (Object)clazz));
                }
                if (!method.isAnnotationPresent(Initialization.class)) continue;
                initializationMethods.add(new Pair((Object)method, (Object)clazz));
            }
        }
        beanMethods.sort(Comparator.comparingInt(m -> ((Method)m.getKey()).getAnnotation(ABean.class).priority()));
        initializationMethods.sort(Comparator.comparingInt(m -> ((Method)m.getKey()).getAnnotation(Initialization.class).priority()));
        LinkedList<Object> beans = new LinkedList<Object>();
        ArrayList<DestroyableBean> arrayList = new ArrayList<DestroyableBean>();
        for (Pair beanMethod : beanMethods) {
            Object beanInstance = this.processConfigBean((Class)beanMethod.getValue(), (Method)beanMethod.getKey(), mapping);
            beans.add(beanInstance);
            ABean beanAnnotation = ((Method)beanMethod.getKey()).getAnnotation(ABean.class);
            if (beanAnnotation.destroyMethod().isEmpty()) continue;
            try {
                Method destroyMethod = beanInstance.getClass().getMethod(beanAnnotation.destroyMethod(), new Class[0]);
                arrayList.add(new DestroyableBean(beanInstance, destroyMethod));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        for (Pair beanMethod : initializationMethods) {
            this.processConfigInitialization((Class)beanMethod.getValue(), (Method)beanMethod.getKey(), mapping);
        }
        return new MultiResult(true, beans, arrayList);
    }

    public Object processConfigBean(Class<?> clazz, Method method, Map<Class<Object>, Class<? extends Object>> mapping) {
        Class<?> returnType;
        log.info("start init config bean:{}", (Object)method);
        Object object = Aop.get(clazz, mapping);
        Object bean = null;
        try {
            bean = method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        Class<?> realBeanClass = null;
        String beanClassName = null;
        realBeanClass = bean.getClass();
        beanClassName = realBeanClass.getName();
        ABean beanAnnotation = method.getAnnotation(ABean.class);
        if (!beanAnnotation.initMethod().isEmpty()) {
            Method initMethod = null;
            try {
                initMethod = realBeanClass.getMethod(beanAnnotation.initMethod(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            try {
                initMethod.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (!(returnType = method.getReturnType()).getName().equals(realBeanClass.getName())) {
            AopManager.me().addMapping(returnType, realBeanClass);
            log.info("add bean mapping:{} from {}", returnType, (Object)beanClassName);
        }
        AopManager.me().addSingletonObject(bean);
        Aop.inject(bean);
        return bean;
    }

    public void processConfigInitialization(Class<?> clazz, Method method, Map<Class<Object>, Class<? extends Object>> mapping) {
        try {
            method.invoke(Aop.get(clazz, mapping), new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

