/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.aop.process;

import com.litongjava.annotation.AAutowired;
import com.litongjava.annotation.AConfiguration;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.jfinal.aop.process.ConfigurationAnnotaionProcess;
import com.litongjava.jfinal.model.DestroyableBean;
import com.litongjava.model.result.MultiResult;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;

public class BeanProcess {
    private Queue<Class<?>> componentClass = new LinkedList();
    private Queue<Class<?>> configurationClass = new LinkedList();

    public void initAnnotation(List<Class<?>> scannedClasses) {
        if (scannedClasses == null || scannedClasses.size() < 1) {
            return;
        }
        ConfigurationAnnotaionProcess configurationAnnotaionProcess = new ConfigurationAnnotaionProcess();
        ConcurrentHashMap<Class<Object>, Class<? extends Object>> mapping = new ConcurrentHashMap<Class<Object>, Class<? extends Object>>();
        for (Class<?> clazz : scannedClasses) {
            boolean annotationPresent = clazz.isAnnotationPresent(AConfiguration.class);
            if (annotationPresent) {
                this.configurationClass.add(clazz);
                continue;
            }
            if (!Aop.isComponent(clazz)) continue;
            this.componentClass.add(clazz);
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length <= 0) continue;
            mapping.put(interfaces[0], clazz);
        }
        MultiResult<Queue<Object>, List<DestroyableBean>, Void> processConfiguration = configurationAnnotaionProcess.processConfiguration(this.configurationClass, mapping);
        if (processConfiguration != null) {
            List destroyableBeans = (List)processConfiguration.getR2();
            Aop.addDestroyableBeans(destroyableBeans);
        }
        this.processComponent(this.componentClass, mapping);
    }

    public Queue<Object> processComponent(Queue<Class<?>> componentClass, Map<Class<Object>, Class<? extends Object>> mapping) {
        LinkedList<Object> componentBeans = new LinkedList<Object>();
        for (Class clazz : componentClass) {
            Object object = Aop.get(clazz, mapping);
            componentBeans.add(object);
        }
        return componentBeans;
    }

    private void processAutowired(Queue<Object> beans) {
        for (Object e : beans) {
            Class<?> clazz = e.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(AAutowired.class)) continue;
                Object value = Aop.get(field.getType());
                try {
                    field.setAccessible(true);
                    field.set(e, value);
                }
                catch (IllegalAccessException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }
}

