/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.aop;

import com.litongjava.jfinal.aop.Aop;
import com.litongjava.jfinal.aop.AopInterceptor;
import com.litongjava.jfinal.aop.AopInvocation;
import com.litongjava.jfinal.aop.AopManager;
import com.litongjava.jfinal.aop.InvocationWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class InterceptorStack
implements AopInterceptor {
    private AopInterceptor[] inters;
    private List<AopInterceptor> interList;

    public InterceptorStack() {
        this.config();
        if (this.interList == null) {
            throw new RuntimeException("You must invoke addInterceptors(...) to config your InterceptorStack");
        }
        this.inters = this.interList.toArray(new AopInterceptor[this.interList.size()]);
        this.interList.clear();
        this.interList = null;
    }

    protected InterceptorStack addInterceptors(AopInterceptor ... interceptors) {
        if (interceptors == null || interceptors.length == 0) {
            throw new IllegalArgumentException("Interceptors can not be null");
        }
        if (this.interList == null) {
            this.interList = new ArrayList<AopInterceptor>();
        }
        for (AopInterceptor ref : interceptors) {
            if (AopManager.me().isInjectDependency()) {
                Aop.inject(ref);
            }
            this.interList.add(ref);
        }
        return this;
    }

    @Override
    public final void intercept(AopInvocation inv) {
        new InvocationWrapper(inv, this.inters).invoke();
    }

    public abstract void config();
}

