/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.aop;

import com.litongjava.annotation.AConfiguration;
import com.litongjava.jfinal.aop.AopFactory;
import com.litongjava.jfinal.aop.context.AopContext;
import com.litongjava.jfinal.aop.process.BeanProcess;
import com.litongjava.jfinal.aop.process.BeforeStartConfigurationProcess;
import com.litongjava.jfinal.aop.process.ComponentAnnotation;
import com.litongjava.jfinal.aop.scanner.ComponentScanner;
import com.litongjava.jfinal.aop.scanner.DefaultComponentScanner;
import com.litongjava.jfinal.model.DestroyableBean;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

public class Aop {
    static AopFactory aopFactory = new AopFactory();

    public static <T> T get(Class<T> targetClass) {
        return aopFactory.get(targetClass);
    }

    public static <T> T getSingleton(Class<T> targetClass) {
        return aopFactory.getSingleton(targetClass);
    }

    public static <T> T getPrototype(Class<T> targetClass) {
        return aopFactory.getPrototype(targetClass);
    }

    public static <T> T get(Class<T> targetClass, Map<Class<Object>, Class<? extends Object>> mapping) {
        return aopFactory.getWithMapping(targetClass, mapping);
    }

    public static <T> T inject(T targetObject) {
        return aopFactory.inject(targetObject);
    }

    public static void put(Class<?> type, Object value) {
        aopFactory.register(type, value);
    }

    public static String[] beans() {
        return aopFactory.beans();
    }

    public static void close() {
        aopFactory.clean();
    }

    public static void addDestroyableBeans(List<DestroyableBean> destroyableBeans) {
        aopFactory.addDestroyableBeans(destroyableBeans);
    }

    public static boolean isComponent(Class<?> clazz) {
        return ComponentAnnotation.isComponent(clazz);
    }

    public static Class<?> addComponentAnnotation(Class<? extends Annotation> clazz) {
        return ComponentAnnotation.addComponentAnnotation(clazz);
    }

    public static boolean isConfiguration(Class<?> clazz) {
        return clazz.isAnnotationPresent(AConfiguration.class);
    }

    public static List<Class<?>> scan(Class<?> ... primarySources) throws Exception {
        ComponentScanner componentScanner = AopContext.me().getComponentScanner();
        if (componentScanner != null) {
            return componentScanner.scan(primarySources, false);
        }
        return new DefaultComponentScanner().scan(primarySources, false);
    }

    public static void initAnnotation(List<Class<?>> scannedClasses) {
        new BeanProcess().initAnnotation(scannedClasses);
    }

    public static List<Class<?>> processBeforeStartConfiguration(List<Class<?>> scannedClasses) {
        return new BeforeStartConfigurationProcess().process(scannedClasses);
    }

    public static void addFetchBeanAnnotation(Class<? extends Annotation> claszz) {
        aopFactory.addFetchBeanAnnotation(claszz);
    }

    @SafeVarargs
    public static void addFetchBeanAnnotations(Class<? extends Annotation> ... classes) {
        aopFactory.addFetchBeanAnnotations(classes);
    }
}

