/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.openai.whisper;

import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.ContentTypeUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.hutool.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WhisperClient {
    public static ResponseVo transcriptions(String filename, byte[] audioBytes, String responseFormat) {
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        return WhisperClient.transcriptions(apiKey, filename, audioBytes, responseFormat);
    }

    public static ResponseVo transcriptions(File file, String responseFormat) {
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        return WhisperClient.transcriptions(apiKey, file, responseFormat);
    }

    public static ResponseVo transcriptions(String apiKey, File file, String responseFormat) {
        String apiPrefixUrl = EnvUtils.get((String)"OPENAI_API_URL", (String)"https://api.openai.com/v1");
        return WhisperClient.transcriptions(apiPrefixUrl, apiKey, file, responseFormat);
    }

    public static ResponseVo transcriptions(String apiKey, String filename, byte[] audioBytes, String responseFormat) {
        String apiPrefixUrl = EnvUtils.get((String)"OPENAI_API_URL", (String)"https://api.openai.com/v1");
        return WhisperClient.transcriptions(apiPrefixUrl, apiKey, filename, audioBytes, responseFormat);
    }

    public static ResponseVo transcriptions(String baseUrl, String apiKey, String filename, byte[] audioBytes, String responseFormat) {
        String contentType = ContentTypeUtils.getContentType((String)FilenameUtils.getSuffix((String)filename));
        RequestBody fileBody = RequestBody.create((byte[])audioBytes, (MediaType)MediaType.get((String)contentType));
        return WhisperClient.transcriptions(baseUrl, apiKey, filename, responseFormat, fileBody);
    }

    public static ResponseVo transcriptions(String baseUrl, String apiKey, File file, String responseFormat) {
        String filename = file.getName();
        String contentType = ContentTypeUtils.getContentType((String)FilenameUtils.getSuffix((String)filename));
        RequestBody fileBody = RequestBody.create((File)file, (MediaType)MediaType.get((String)contentType));
        return WhisperClient.transcriptions(baseUrl, apiKey, filename, responseFormat, fileBody);
    }

    public static ResponseVo transcriptions(String baseUrl, String apiKey, String filename, String responseFormat, RequestBody fileBody) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + apiKey);
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MultipartBody.FORM);
        bodyBuilder.addFormDataPart("response_format", responseFormat);
        bodyBuilder.addFormDataPart("model", "whisper-1");
        bodyBuilder.addFormDataPart("file", filename, fileBody);
        MultipartBody formBody = bodyBuilder.build();
        return WhisperClient.execute(baseUrl, header, formBody);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResponseVo execute(String baseUrl, Map<String, String> header, MultipartBody formBody) {
        String url = baseUrl + "/audio/transcriptions";
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)formBody);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = requestBuilder.build();
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        try (Response response = httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            int code = response.code();
            if (response.isSuccessful()) {
                ResponseVo responseVo = ResponseVo.ok((String)responseBody);
                return responseVo;
            }
            ResponseVo responseVo = ResponseVo.fail((int)code, (String)responseBody);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

