/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.openai.chat;

import com.litongjava.chat.ChatFile;
import com.litongjava.chat.ChatMessage;
import com.litongjava.claude.ClaudeMessageContent;
import com.litongjava.openai.chat.ChatMesageContent;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.ArrayList;
import java.util.List;

public class OpenAiChatMessage {
    private String role;
    private Object content;
    private Boolean prefix;

    public static OpenAiChatMessage buildSystem(String content) {
        return new OpenAiChatMessage("system", content);
    }

    public static OpenAiChatMessage buildAssistant(String content) {
        return new OpenAiChatMessage("assistant", content);
    }

    public static OpenAiChatMessage buildUser(String content) {
        return new OpenAiChatMessage("user", content);
    }

    public static OpenAiChatMessage buildFunction(String content) {
        return new OpenAiChatMessage("function", content);
    }

    public static OpenAiChatMessage buildTool(String content) {
        return new OpenAiChatMessage("tool", content);
    }

    public static OpenAiChatMessage buildDeveloper(String content) {
        return new OpenAiChatMessage("developer", content);
    }

    public OpenAiChatMessage(String prompt) {
        this.role = "user";
        this.content = prompt;
    }

    public OpenAiChatMessage(ChatMessage chatMessage) {
        this.role = chatMessage.getRole();
        this.content = chatMessage.getContent();
    }

    public OpenAiChatMessage(String role, String prompt) {
        this.role = role;
        this.content = prompt;
    }

    public void setContent(String prompt) {
        this.content = prompt;
    }

    public OpenAiChatMessage content(String prompt) {
        this.setContent(prompt);
        return this;
    }

    public OpenAiChatMessage multiContents(List<ChatMesageContent> multiContents) {
        this.content = multiContents;
        return this;
    }

    public OpenAiChatMessage role(String role) {
        this.role = role;
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public Object getContent() {
        return this.content;
    }

    public String role() {
        return this.role;
    }

    public Object content() {
        return this.content;
    }

    public Boolean getPrefix() {
        return this.prefix;
    }

    public void setPrefix(Boolean prefix) {
        this.prefix = prefix;
    }

    public OpenAiChatMessage(ChatMessage message, String provider) {
        this.role = message.getRole();
        String content = message.getContent();
        if ("anthropic".equals(provider)) {
            if (message.getFiles() != null && message.getFiles().size() > 0) {
                ArrayList<ClaudeMessageContent> messageContents = new ArrayList<ClaudeMessageContent>();
                List<ChatFile> files = message.getFiles();
                for (ChatFile file : files) {
                    ClaudeMessageContent e = new ClaudeMessageContent(file);
                    messageContents.add(e);
                }
                if (StrUtil.isNotBlank((CharSequence)content)) {
                    messageContents.add(new ClaudeMessageContent("text", content));
                }
                this.content = messageContents;
            } else {
                this.content = content;
            }
        } else {
            this.role = message.getRole();
            this.content = content;
        }
    }

    public static OpenAiChatMessageBuilder builder() {
        return new OpenAiChatMessageBuilder();
    }

    public OpenAiChatMessage() {
    }

    public OpenAiChatMessage(String role, Object content, Boolean prefix) {
        this.role = role;
        this.content = content;
        this.prefix = prefix;
    }

    public static class OpenAiChatMessageBuilder {
        private String role;
        private Object content;
        private Boolean prefix;

        OpenAiChatMessageBuilder() {
        }

        public OpenAiChatMessageBuilder role(String role) {
            this.role = role;
            return this;
        }

        public OpenAiChatMessageBuilder content(Object content) {
            this.content = content;
            return this;
        }

        public OpenAiChatMessageBuilder prefix(Boolean prefix) {
            this.prefix = prefix;
            return this;
        }

        public OpenAiChatMessage build() {
            return new OpenAiChatMessage(this.role, this.content, this.prefix);
        }

        public String toString() {
            return "OpenAiChatMessage.OpenAiChatMessageBuilder(role=" + this.role + ", content=" + this.content + ", prefix=" + this.prefix + ")";
        }
    }
}

