/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.google.search;

import com.litongjava.google.search.GoogleCustomSearchResponse;
import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.Http;
import com.litongjava.tio.utils.json.JsonUtils;
import com.litongjava.tio.utils.url.UrlUtils;

public class GoogleCustomSearchClient {
    public static final String SEARCH_URL = "https://www.googleapis.com/customsearch/v1?key=%s&cx=%s&q=%s";

    public static GoogleCustomSearchResponse search(String key, String cx, String q) {
        String encode = UrlUtils.encode((String)q);
        String url = String.format(SEARCH_URL, key, cx, encode);
        ResponseVo responseVo = Http.get((String)url);
        if (responseVo.isOk()) {
            String bodyString = responseVo.getBodyString();
            return (GoogleCustomSearchResponse)JsonUtils.parse((String)bodyString, GoogleCustomSearchResponse.class);
        }
        throw new RuntimeException("request:" + url + " response:" + responseVo.getBodyString());
    }

    public static GoogleCustomSearchResponse search(String q) {
        String key = EnvUtils.getStr((String)"GOOGLE_API_KEY");
        String ctx = EnvUtils.getStr((String)"GOOGLE_SEARCH_CTX");
        return GoogleCustomSearchClient.search(key, ctx, q);
    }
}

