/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.chat;

import com.litongjava.chat.ChatFile;
import com.litongjava.chat.ChatMessage;
import com.litongjava.chat.UniChatRequest;
import com.litongjava.chat.UniChatResponse;
import com.litongjava.claude.ClaudeCacheControl;
import com.litongjava.claude.ClaudeChatResponseVo;
import com.litongjava.claude.ClaudeClient;
import com.litongjava.claude.ClaudeMessageContent;
import com.litongjava.gemini.GeminiChatRequestVo;
import com.litongjava.gemini.GeminiChatResponseVo;
import com.litongjava.gemini.GeminiClient;
import com.litongjava.gemini.GeminiContentResponseVo;
import com.litongjava.gemini.GeminiGenerationConfigVo;
import com.litongjava.gemini.GeminiPartVo;
import com.litongjava.gemini.GeminiThinkingConfig;
import com.litongjava.gemini.GeminiUsageMetadataVo;
import com.litongjava.openai.chat.ChatMesageContent;
import com.litongjava.openai.chat.ChatRequestImage;
import com.litongjava.openai.chat.ChatResponseMessage;
import com.litongjava.openai.chat.ChatResponseUsage;
import com.litongjava.openai.chat.OpenAiChatMessage;
import com.litongjava.openai.chat.OpenAiChatRequestVo;
import com.litongjava.openai.chat.OpenAiChatResponseVo;
import com.litongjava.openai.client.OpenAiClient;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.ArrayList;
import java.util.List;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;

public class UniChatClient {
    public static final String OPENAI_API_URL = EnvUtils.get((String)"OPENAI_API_URL", (String)"https://api.openai.com/v1");
    public static final String VOLCENGINE_API_URL = EnvUtils.get((String)"VOLCENGINE_API_URL", (String)"https://ark.cn-beijing.volces.com/api/v3");
    public static final String OPENROUTER_API_URL = EnvUtils.get((String)"OPENROUTER_API_URL", (String)"https://openrouter.ai/api/v1");
    public static final String BAILIAN_API_URL = EnvUtils.get((String)"BAILIAN_API_URL", (String)"https://dashscope.aliyuncs.com/compatible-mode/v1");
    public static final String TENCENT_API_URL = EnvUtils.get((String)"TENCENT_API_URL", (String)"https://api.lkeap.cloud.tencent.com/v1");
    public static final String MOONSHOT_API_URL = EnvUtils.get((String)"MOONSHOT_API_URL", (String)"https://api.moonshot.cn/v1");
    public static final String MINIMAX_API_URL = EnvUtils.get((String)"MINIMAX_API_URL", (String)"https://api.minimax.io/v1");

    public static UniChatResponse generate(UniChatRequest uniChatRequest) {
        return UniChatClient.generate(uniChatRequest.getApiKey(), uniChatRequest);
    }

    public static UniChatResponse generate(String key, UniChatRequest uniChatRequest) {
        if ("google".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useGemeni(key, uniChatRequest);
        }
        if ("anthropic".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useClaude(key, uniChatRequest);
        }
        if ("volcengine".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useVolcEngine(key, uniChatRequest);
        }
        if ("openrouter".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useOpenRouter(key, uniChatRequest);
        }
        if ("bailian".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useBailian(key, uniChatRequest);
        }
        if ("tencent".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useTencent(key, uniChatRequest);
        }
        if ("minimax".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useMiniMax(key, uniChatRequest);
        }
        return UniChatClient.useOpenAi(key, uniChatRequest);
    }

    public static UniChatResponse useOpenAi(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(OPENAI_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useVolcEngine(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(VOLCENGINE_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useOpenRouter(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(OPENROUTER_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useBailian(String key, UniChatRequest uniChatRequest) {
        uniChatRequest.setEnable_thinking(false);
        return UniChatClient.useOpenAi(BAILIAN_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useTencent(String key, UniChatRequest uniChatRequest) {
        uniChatRequest.setEnable_thinking(false);
        return UniChatClient.useOpenAi(TENCENT_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useMiniMax(String key, UniChatRequest uniChatRequest) {
        uniChatRequest.setEnable_thinking(false);
        return UniChatClient.useOpenAi(MINIMAX_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useOpenAi(String prefixUrl, String apiKey, UniChatRequest uniChatRequest) {
        String systemPrompt;
        List<ChatMessage> messages = uniChatRequest.getMessages();
        ArrayList<OpenAiChatMessage> openAiChatMesages = new ArrayList<OpenAiChatMessage>();
        for (ChatMessage next : messages) {
            List<ChatFile> files;
            String content;
            String role = next.getRole();
            if (next.getRole().equals("model")) {
                role = "assistant";
            }
            if ((content = next.getContent()) != null) {
                openAiChatMesages.add(new OpenAiChatMessage(role, content));
            }
            if ((files = next.getFiles()) == null || files.size() <= 0) continue;
            ArrayList<ChatMesageContent> multiContents = new ArrayList<ChatMesageContent>();
            for (ChatFile file : files) {
                String data = file.getData();
                ChatRequestImage chatRequestImage = new ChatRequestImage();
                chatRequestImage.setDetail("auto");
                chatRequestImage.setUrl(data);
                ChatMesageContent image = new ChatMesageContent(chatRequestImage);
                multiContents.add(image);
            }
            OpenAiChatMessage openAiFileMesage = new OpenAiChatMessage();
            openAiFileMesage.role(role);
            openAiFileMesage.multiContents(multiContents);
            openAiChatMesages.add(openAiFileMesage);
        }
        if (uniChatRequest.isUseSystemPrompt() && StrUtil.isNotBlank((CharSequence)(systemPrompt = uniChatRequest.getSystemPrompt()))) {
            openAiChatMesages.add(0, new OpenAiChatMessage("system", systemPrompt));
        }
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        openAiChatRequestVo.setMessages(openAiChatMesages);
        openAiChatRequestVo.setModel(uniChatRequest.getModel());
        openAiChatRequestVo.setTemperature(uniChatRequest.getTemperature());
        openAiChatRequestVo.setMax_tokens(uniChatRequest.getMax_tokens());
        openAiChatRequestVo.setEnable_thinking(uniChatRequest.getEnable_thinking());
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        OpenAiChatResponseVo chatCompletions = null;
        chatCompletions = apiPrefixUrl != null ? OpenAiClient.chatCompletions(apiPrefixUrl, apiKey, openAiChatRequestVo) : OpenAiClient.chatCompletions(prefixUrl, apiKey, openAiChatRequestVo);
        if (chatCompletions == null) {
            return null;
        }
        ChatResponseMessage message = chatCompletions.getChoices().get(0).getMessage();
        ChatResponseUsage usage = chatCompletions.getUsage();
        String model = chatCompletions.getModel();
        return new UniChatResponse(model, message, usage);
    }

    public static UniChatResponse useClaude(String key, UniChatRequest uniChatRequest) {
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        List<ChatMessage> messages = uniChatRequest.getMessages();
        for (ChatMessage next : messages) {
            if (!next.getRole().equals("model")) continue;
            next.setRole("assistant");
        }
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        if (uniChatRequest.isUseSystemPrompt()) {
            String systemPrompt = uniChatRequest.getSystemPrompt();
            if ("anthropic".equals(uniChatRequest.getProvider())) {
                ClaudeMessageContent claudeChatMessage = new ClaudeMessageContent("text", systemPrompt);
                if (uniChatRequest.isCacheSystemPrompt()) {
                    claudeChatMessage.setCache_control(new ClaudeCacheControl());
                }
                openAiChatRequestVo.setSystemChatMessage(claudeChatMessage);
            }
        }
        openAiChatRequestVo.setModel(uniChatRequest.getModel());
        openAiChatRequestVo.setTemperature(uniChatRequest.getTemperature());
        openAiChatRequestVo.setChatMessages(messages, uniChatRequest.getProvider());
        openAiChatRequestVo.setMax_tokens(uniChatRequest.getMax_tokens());
        ClaudeChatResponseVo chatCompletions = null;
        chatCompletions = apiPrefixUrl != null ? ClaudeClient.chatCompletions(apiPrefixUrl, key, openAiChatRequestVo) : ClaudeClient.chatCompletions(key, openAiChatRequestVo);
        if (chatCompletions == null) {
            return null;
        }
        String role = chatCompletions.getRole();
        String model = chatCompletions.getModel();
        ClaudeMessageContent claudeChatMessage = chatCompletions.getContent().get(0);
        ChatResponseMessage message = new ChatResponseMessage(role, claudeChatMessage.getText());
        ChatResponseUsage usage = new ChatResponseUsage(chatCompletions.getUsage());
        return new UniChatResponse(model, message, usage);
    }

    public static UniChatResponse useGemeni(String key, UniChatRequest uniChatRequest) {
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        GeminiChatRequestVo geminiChatRequestVo = new GeminiChatRequestVo();
        geminiChatRequestVo.setChatMessages(uniChatRequest.getMessages());
        String cachedId = uniChatRequest.getCachedId();
        if (cachedId != null) {
            geminiChatRequestVo.setCachedContent(cachedId);
        } else {
            geminiChatRequestVo.setSystemPrompt(uniChatRequest.getSystemPrompt());
        }
        Boolean enable_thinking = uniChatRequest.getEnable_thinking();
        GeminiGenerationConfigVo geminiGenerationConfigVo = new GeminiGenerationConfigVo();
        Float temperature = uniChatRequest.getTemperature();
        if (temperature != null) {
            geminiGenerationConfigVo.setTemperature(temperature);
        }
        if (enable_thinking != null && !enable_thinking.booleanValue()) {
            GeminiThinkingConfig geminiThinkingConfig = new GeminiThinkingConfig(0);
            geminiGenerationConfigVo.setThinkingConfig(geminiThinkingConfig);
        }
        geminiChatRequestVo.setGenerationConfig(geminiGenerationConfigVo);
        GeminiChatResponseVo chatResponse = null;
        chatResponse = apiPrefixUrl != null ? GeminiClient.generate(apiPrefixUrl, key, uniChatRequest.getModel(), geminiChatRequestVo) : GeminiClient.generate(key, uniChatRequest.getModel(), geminiChatRequestVo);
        if (chatResponse == null) {
            return null;
        }
        GeminiContentResponseVo content = chatResponse.getCandidates().get(0).getContent();
        String modelVersion = chatResponse.getModelVersion();
        String role = content.getRole();
        GeminiPartVo geminiPartVo = content.getParts().get(0);
        GeminiUsageMetadataVo usageMetadata = chatResponse.getUsageMetadata();
        ChatResponseUsage usage = new ChatResponseUsage(usageMetadata);
        ChatResponseMessage message = new ChatResponseMessage(role, geminiPartVo);
        return new UniChatResponse(modelVersion, message, usage);
    }

    public static EventSource stream(UniChatRequest uniChatRequest, EventSourceListener listener) {
        return UniChatClient.stream(uniChatRequest.getApiKey(), uniChatRequest, listener);
    }

    public static EventSource stream(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        if ("google".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useGemeni(key, uniChatRequest, listener);
        }
        if ("anthropic".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useClaude(key, uniChatRequest, listener);
        }
        if ("volcengine".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useVolcEngine(key, uniChatRequest, listener);
        }
        if ("openrouter".equals(uniChatRequest.getProvider())) {
            return UniChatClient.useOpenRouter(key, uniChatRequest, listener);
        }
        return UniChatClient.useOpenAi(key, uniChatRequest, listener);
    }

    public static EventSource useVolcEngine(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        return UniChatClient.useOpenAi(VOLCENGINE_API_URL, key, uniChatRequest, listener);
    }

    public static EventSource useOpenRouter(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        return UniChatClient.useOpenAi(OPENROUTER_API_URL, key, uniChatRequest, listener);
    }

    public static EventSource useOpenAi(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        return UniChatClient.useOpenAi(OPENAI_API_URL, key, uniChatRequest, listener);
    }

    public static EventSource useOpenAi(String prefixUrl, String apiKey, UniChatRequest uniChatRequest, EventSourceListener listener) {
        List<ChatMessage> messages = uniChatRequest.getMessages();
        for (ChatMessage next : messages) {
            if (!next.getRole().equals("model")) continue;
            next.setRole("assistant");
        }
        if (uniChatRequest.isUseSystemPrompt()) {
            messages.add(0, new ChatMessage("system", uniChatRequest.getSystemPrompt()));
        }
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        openAiChatRequestVo.setModel(uniChatRequest.getModel());
        openAiChatRequestVo.setTemperature(uniChatRequest.getTemperature());
        openAiChatRequestVo.setChatMessages(messages);
        openAiChatRequestVo.setMax_tokens(uniChatRequest.getMax_tokens());
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        EventSource eventSource = null;
        eventSource = apiPrefixUrl != null ? OpenAiClient.chatCompletions(apiPrefixUrl, apiKey, openAiChatRequestVo, listener) : OpenAiClient.chatCompletions(prefixUrl, apiKey, openAiChatRequestVo, listener);
        return eventSource;
    }

    public static EventSource useClaude(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        List<ChatMessage> messages = uniChatRequest.getMessages();
        for (ChatMessage next : messages) {
            if (!next.getRole().equals("model")) continue;
            next.setRole("assistant");
        }
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        if (uniChatRequest.isUseSystemPrompt()) {
            String systemPrompt = uniChatRequest.getSystemPrompt();
            if ("anthropic".equals(uniChatRequest.getProvider())) {
                ClaudeMessageContent claudeChatMessage = new ClaudeMessageContent("text", systemPrompt);
                if (uniChatRequest.isCacheSystemPrompt()) {
                    claudeChatMessage.setCache_control(new ClaudeCacheControl());
                }
                openAiChatRequestVo.setSystemChatMessage(claudeChatMessage);
            }
        }
        openAiChatRequestVo.setModel(uniChatRequest.getModel());
        openAiChatRequestVo.setTemperature(uniChatRequest.getTemperature());
        openAiChatRequestVo.setChatMessages(messages, uniChatRequest.getProvider());
        openAiChatRequestVo.setMax_tokens(uniChatRequest.getMax_tokens());
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        EventSource eventSource = null;
        eventSource = apiPrefixUrl == null ? ClaudeClient.chatCompletions(apiPrefixUrl, key, openAiChatRequestVo, listener) : ClaudeClient.chatCompletions(key, openAiChatRequestVo, listener);
        return eventSource;
    }

    public static EventSource useGemeni(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        GeminiGenerationConfigVo geminiGenerationConfigVo = new GeminiGenerationConfigVo();
        geminiGenerationConfigVo.setTemperature(uniChatRequest.getTemperature());
        GeminiChatRequestVo geminiChatRequestVo = new GeminiChatRequestVo();
        geminiChatRequestVo.setGenerationConfig(geminiGenerationConfigVo);
        geminiChatRequestVo.setSystemPrompt(uniChatRequest.getSystemPrompt());
        geminiChatRequestVo.setChatMessages(uniChatRequest.getMessages());
        geminiChatRequestVo.setCachedContent(uniChatRequest.getCachedId());
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        EventSource eventSource = null;
        eventSource = apiPrefixUrl != null ? GeminiClient.stream(apiPrefixUrl, key, uniChatRequest.getModel(), geminiChatRequestVo, listener) : GeminiClient.stream(key, uniChatRequest.getModel(), geminiChatRequestVo, listener);
        return eventSource;
    }
}

