/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.api;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCooldownManager {
    private static final Logger log = LoggerFactory.getLogger(ApiCooldownManager.class);
    private final ConcurrentMap<String, Long> cooldownUntilTimestamps = new ConcurrentHashMap<String, Long>();
    private final long COOLDOWN_BUFFER_MS = 500L;

    public void enforceCooldown(String serviceKey) throws InterruptedException {
        long delay;
        long now;
        Long cooldownUntil = (Long)this.cooldownUntilTimestamps.get(serviceKey);
        if (cooldownUntil != null && (now = System.currentTimeMillis()) < cooldownUntil && (delay = cooldownUntil - now) > 0L) {
            log.info("Global cooldown active for service '{}'. Delaying current request for {} ms.", (Object)serviceKey, (Object)delay);
            Thread.sleep(delay);
        }
    }

    public void recordCooldown(String serviceKey, long actualRetryDelayMillis) {
        if (actualRetryDelayMillis <= 0L) {
            return;
        }
        long newCooldownUntil = System.currentTimeMillis() + actualRetryDelayMillis + 500L;
        this.cooldownUntilTimestamps.merge(serviceKey, newCooldownUntil, Math::max);
        log.info("Global cooldown for service '{}' updated. Next requests will be allowed after timestamp: {} (approx. {} ms from now).", new Object[]{serviceKey, newCooldownUntil, newCooldownUntil - System.currentTimeMillis()});
    }
}

