/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.template;

import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Locale;

public class LocaleDateDirective
extends Directive {
    private Expr dateExpr;
    private Expr patternExpr;
    private Expr localeExpr;

    public void setExprList(ExprList exprList) {
        int paraNum = exprList.length();
        if (paraNum == 0) {
            this.dateExpr = null;
            this.patternExpr = null;
            this.localeExpr = null;
        } else if (paraNum == 1) {
            this.dateExpr = exprList.getExpr(0);
            this.patternExpr = null;
            this.localeExpr = null;
        } else if (paraNum == 2) {
            this.dateExpr = exprList.getExpr(0);
            this.patternExpr = exprList.getExpr(1);
            this.localeExpr = null;
        } else if (paraNum == 3) {
            this.dateExpr = exprList.getExpr(0);
            this.patternExpr = exprList.getExpr(1);
            this.localeExpr = exprList.getExpr(2);
        } else {
            throw new ParseException("Wrong number parameter of #localeDate directive, three parameters allowed at most", this.location);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exec(Env env, Scope scope, Writer writer) {
        String pattern;
        Locale locale = Locale.getDefault();
        Object date = this.dateExpr != null ? this.dateExpr.eval(scope) : new Date();
        if (this.patternExpr != null) {
            Object temp = this.patternExpr.eval(scope);
            if (!(temp instanceof String)) throw new TemplateException("The second parameter datePattern of #localeDate directive must be String", this.location);
            pattern = (String)temp;
        } else {
            pattern = env.getEngineConfig().getDatePattern();
        }
        if (this.localeExpr != null) {
            Object localeVal = this.localeExpr.eval(scope);
            if (localeVal instanceof Locale) {
                locale = (Locale)localeVal;
            } else {
                if (!(localeVal instanceof String)) throw new TemplateException("The third parameter locale of #localeDate directive must be Locale or String", this.location);
                locale = new Locale((String)localeVal);
            }
        }
        this.write(date, pattern, locale, writer);
    }

    private void write(Object date, String pattern, Locale locale, Writer writer) {
        try {
            if (date instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
                writer.write(sdf.format((Date)date));
            } else if (date instanceof Temporal) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, locale);
                writer.write(formatter.format((Temporal)date));
            } else if (date != null) {
                throw new TemplateException("The first parameter of #localeDate directive cannot be " + date.getClass().getName(), this.location);
            }
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, (Throwable)e);
        }
    }
}

