/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.redis;

import com.jfinal.kit.StrKit;
import com.litongjava.redis.IRedisCallback;
import com.litongjava.redis.RedisDb;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import redis.clients.jedis.Jedis;

public class Redis {
    static RedisDb mainCache = null;
    private static final ConcurrentHashMap<String, RedisDb> cacheMap = new ConcurrentHashMap(32, 0.5f);

    public static void addCache(RedisDb cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache can not be null");
        }
        if (cacheMap.containsKey(cache.getName())) {
            throw new IllegalArgumentException("The cache name already exists");
        }
        cacheMap.put(cache.getName(), cache);
        if (mainCache == null) {
            mainCache = cache;
        }
    }

    public static RedisDb removeCache(String cacheName) {
        return cacheMap.remove(cacheName);
    }

    public static void setMainCache(String cacheName) {
        if (StrKit.isBlank((String)cacheName)) {
            throw new IllegalArgumentException("cacheName can not be blank");
        }
        RedisDb cache = cacheMap.get(cacheName = cacheName.trim());
        if (cache == null) {
            throw new IllegalArgumentException("the cache not exists: " + cacheName);
        }
        mainCache = cache;
    }

    public static RedisDb use() {
        return mainCache;
    }

    public static RedisDb use(String cacheName) {
        return cacheMap.get(cacheName);
    }

    public static <R> R call(Function<Jedis, R> jedis) {
        return Redis.use().call(jedis);
    }

    public static <R> R call(String cacheName, Function<Jedis, R> jedis) {
        return Redis.use(cacheName).call(jedis);
    }

    public static <T> T callback(IRedisCallback<T> callback) {
        return Redis.callback(Redis.use(), callback);
    }

    public static <T> T callback(String cacheName, IRedisCallback<T> callback) {
        return Redis.callback(Redis.use(cacheName), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T callback(RedisDb cache, IRedisCallback<T> callback) {
        boolean notThreadLocalJedis;
        Jedis jedis = cache.getThreadLocalJedis();
        boolean bl = notThreadLocalJedis = jedis == null;
        if (notThreadLocalJedis) {
            jedis = cache.jedisPool.getResource();
            cache.setThreadLocalJedis(jedis);
        }
        try {
            T t = callback.call(cache);
            return t;
        }
        finally {
            if (notThreadLocalJedis) {
                cache.removeThreadLocalJedis();
                jedis.close();
            }
        }
    }

    public static <R> R getBean(String key, Class<R> type) {
        return Redis.use().getBean(key, type);
    }

    public static String setBean(String key, long seconds, Object input) {
        return Redis.use().setBean(key, seconds, input);
    }

    public static String setBean(String key, Object input) {
        return Redis.use().setBean(key, input);
    }

    public static String setStr(String key, String input) {
        return Redis.use().setStr(key, input);
    }

    public static <R> String setStr(String key, long seconds, String input) {
        return Redis.use().set(key, seconds, input);
    }

    public static String getStr(String key) {
        return Redis.use().getStr(key);
    }

    public static String setInt(String key, int value) {
        return Redis.use().setInt(key, value);
    }

    public static String setInt(String key, long seconds, int value) {
        return Redis.use().setInt(key, seconds, value);
    }

    public static Integer getInt(String key) {
        return Redis.use().getInt(key);
    }

    public static String setLong(String key, long value) {
        return Redis.use().setLong(key, value);
    }

    public static String setLong(String key, long seconds, long value) {
        return Redis.use().setLong(key, seconds, value);
    }

    public static Long getLong(String key) {
        return Redis.use().getLong(key);
    }

    public static boolean hasKey(String key) {
        return Redis.use().hasKey(key);
    }
}

