/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.generator;

import com.jfinal.kit.StrKit;
import com.litongjava.db.activerecord.generator.ColumnMeta;
import com.litongjava.db.activerecord.generator.TableMeta;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDictionaryGenerator {
    private static final Logger log = LoggerFactory.getLogger(DataDictionaryGenerator.class);
    protected DataSource dataSource;
    protected String dataDictionaryOutputDir;
    protected String dataDictionaryFileName = "_DataDictionary.txt";

    public DataDictionaryGenerator(DataSource dataSource, String dataDictionaryOutputDir) {
        this.dataSource = dataSource;
        this.dataDictionaryOutputDir = dataDictionaryOutputDir;
    }

    public void setDataDictionaryOutputDir(String dataDictionaryOutputDir) {
        if (StrKit.notBlank((String)dataDictionaryOutputDir)) {
            this.dataDictionaryOutputDir = dataDictionaryOutputDir;
        }
    }

    public String getDataDictionaryOutputDir() {
        return this.dataDictionaryOutputDir;
    }

    public void setDataDictionaryFileName(String dataDictionaryFileName) {
        if (StrKit.notBlank((String)dataDictionaryFileName)) {
            this.dataDictionaryFileName = dataDictionaryFileName;
        }
    }

    public String getDataDictionaryFileName() {
        return this.dataDictionaryFileName;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate DataDictionary file ...");
        System.out.println("Data Dictionary Output Dir: " + this.dataDictionaryOutputDir);
        this.rebuildColumnMetas(tableMetas);
        StringBuilder ret = new StringBuilder();
        for (TableMeta tableMeta : tableMetas) {
            this.generateTable(tableMeta, ret);
        }
        this.writeToFile(ret.toString());
    }

    protected void generateTable(TableMeta tableMeta, StringBuilder ret) {
        ret.append("Table: ").append(tableMeta.name);
        if (StrKit.notBlank((String)tableMeta.remarks)) {
            ret.append("\tRemarks: ").append(tableMeta.remarks);
        }
        ret.append("\n");
        String sparateLine = this.genSeparateLine(tableMeta);
        ret.append(sparateLine);
        this.genTableHead(tableMeta, ret);
        ret.append(sparateLine);
        for (ColumnMeta columnMeta : tableMeta.columnMetas) {
            this.genColumn(tableMeta, columnMeta, ret);
        }
        ret.append(sparateLine);
        ret.append("\n");
    }

    protected void genCell(int columnMaxLen, String preChar, String value, String fillChar, String postChar, StringBuilder ret) {
        ret.append(preChar);
        ret.append(value);
        int n = columnMaxLen - value.length() + 1;
        for (int i = 0; i < n; ++i) {
            ret.append(fillChar);
        }
        ret.append(postChar);
    }

    protected String genSeparateLine(TableMeta tm) {
        StringBuilder ret = new StringBuilder();
        this.genCell(tm.colNameMaxLen, "-", "---", "-", "+", ret);
        this.genCell(tm.colTypeMaxLen, "-", "---", "-", "+", ret);
        this.genCell("Null".length(), "-", "---", "-", "+", ret);
        this.genCell("Key".length(), "-", "---", "-", "+", ret);
        this.genCell(tm.colDefaultValueMaxLen, "-", "---", "-", "+", ret);
        this.genCell("Remarks".length(), "-", "---", "-", "", ret);
        ret.append("\n");
        return ret.toString();
    }

    protected void genTableHead(TableMeta tm, StringBuilder ret) {
        this.genCell(tm.colNameMaxLen, " ", "Field", " ", "|", ret);
        this.genCell(tm.colTypeMaxLen, " ", "Type", " ", "|", ret);
        this.genCell("Null".length(), " ", "Null", " ", "|", ret);
        this.genCell("Key".length(), " ", "Key", " ", "|", ret);
        this.genCell(tm.colDefaultValueMaxLen, " ", "Default", " ", "|", ret);
        this.genCell("Remarks".length(), " ", "Remarks", " ", "", ret);
        ret.append("\n");
    }

    protected void genColumn(TableMeta tableMeta, ColumnMeta columnMeta, StringBuilder ret) {
        this.genCell(tableMeta.colNameMaxLen, " ", columnMeta.name, " ", "|", ret);
        this.genCell(tableMeta.colTypeMaxLen, " ", columnMeta.type, " ", "|", ret);
        this.genCell("Null".length(), " ", columnMeta.isNullable, " ", "|", ret);
        this.genCell("Key".length(), " ", columnMeta.isPrimaryKey, " ", "|", ret);
        this.genCell(tableMeta.colDefaultValueMaxLen, " ", columnMeta.defaultValue, " ", "|", ret);
        this.genCell("Remarks".length(), " ", columnMeta.remarks, " ", "", ret);
        ret.append("\n");
    }

    protected void rebuildColumnMetas(List<TableMeta> tableMetas) {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            DatabaseMetaData dbMeta = conn.getMetaData();
            for (TableMeta tableMeta : tableMetas) {
                tableMeta.columnMetas = new ArrayList<ColumnMeta>();
                ResultSet rs = dbMeta.getColumns(conn.getCatalog(), null, tableMeta.name, null);
                while (rs.next()) {
                    String[] keys;
                    int columnSize;
                    ColumnMeta columnMeta = new ColumnMeta();
                    columnMeta.name = rs.getString("COLUMN_NAME");
                    columnMeta.type = rs.getString("TYPE_NAME");
                    if (columnMeta.type == null) {
                        columnMeta.type = "";
                    }
                    if ((columnSize = rs.getInt("COLUMN_SIZE")) > 0) {
                        columnMeta.type = columnMeta.type + "(" + columnSize;
                        int decimalDigits = rs.getInt("DECIMAL_DIGITS");
                        if (decimalDigits > 0) {
                            columnMeta.type = columnMeta.type + "," + decimalDigits;
                        }
                        columnMeta.type = columnMeta.type + ")";
                    }
                    columnMeta.isPrimaryKey = "   ";
                    for (String key : keys = tableMeta.primaryKey.split(",")) {
                        if (!key.equalsIgnoreCase(columnMeta.name)) continue;
                        columnMeta.isPrimaryKey = "PRI";
                        break;
                    }
                    columnMeta.remarks = rs.getString("REMARKS");
                    if (columnMeta.remarks == null) {
                        columnMeta.remarks = "";
                    }
                    columnMeta.defaultValue = rs.getString("COLUMN_DEF");
                    if (columnMeta.defaultValue == null) {
                        columnMeta.defaultValue = "";
                    }
                    columnMeta.isNullable = rs.getString("IS_NULLABLE");
                    if (columnMeta.isNullable == null) {
                        columnMeta.isNullable = "";
                    }
                    if (tableMeta.colNameMaxLen < columnMeta.name.length()) {
                        tableMeta.colNameMaxLen = columnMeta.name.length();
                    }
                    if (tableMeta.colTypeMaxLen < columnMeta.type.length()) {
                        tableMeta.colTypeMaxLen = columnMeta.type.length();
                    }
                    if (tableMeta.colDefaultValueMaxLen < columnMeta.defaultValue.length()) {
                        tableMeta.colDefaultValueMaxLen = columnMeta.defaultValue.length();
                    }
                    tableMeta.columnMetas.add(columnMeta);
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void writeToFile(String ret) {
        File dir = new File(this.dataDictionaryOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String target = this.dataDictionaryOutputDir + File.separator + this.dataDictionaryFileName;
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(target), "UTF-8");){
            osw.write(ret);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

