/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.dialect;

import com.litongjava.db.activerecord.ActiveRecordException;
import com.litongjava.db.activerecord.CPI;
import com.litongjava.db.activerecord.Model;
import com.litongjava.db.activerecord.ModelBuilder;
import com.litongjava.db.activerecord.Row;
import com.litongjava.db.activerecord.Table;
import com.litongjava.db.activerecord.builder.TimestampProcessedModelBuilder;
import com.litongjava.db.activerecord.builder.TimestampProcessedRecordBuilder;
import com.litongjava.db.activerecord.dialect.Dialect;
import com.litongjava.db.activerecord.dialect.DialectUtils;
import com.litongjava.model.page.Page;
import com.litongjava.tio.utils.json.Json;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnsiSqlDialect
extends Dialect {
    public AnsiSqlDialect() {
        this.modelBuilder = TimestampProcessedModelBuilder.me;
        this.recordBuilder = TimestampProcessedRecordBuilder.me;
    }

    @Override
    public String forTableBuilderDoBuild(String tableName) {
        return "select * from " + tableName + " where 1 = 2";
    }

    @Override
    public void forModelSave(Table table, Map<String, Object> attrs, StringBuilder sql, List<Object> paras) {
        sql.append("insert into ").append(table.getName()).append('(');
        StringBuilder temp = new StringBuilder(") values(");
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append(colName);
            temp.append('?');
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(')');
    }

    @Override
    public String forModelDeleteById(Table table) {
        String[] pKeys = table.getPrimaryKey();
        StringBuilder sql = new StringBuilder(45);
        sql.append("delete from ");
        sql.append(table.getName());
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append(pKeys[i]).append(" = ?");
        }
        return sql.toString();
    }

    @Override
    public String forDbDeleteByField(String tableName, String field) {
        StringBuilder sql = new StringBuilder(45);
        sql.append("delete from ");
        sql.append(tableName);
        sql.append(" where ");
        sql.append(field).append(" = ?");
        return sql.toString();
    }

    @Override
    public void forModelUpdate(Table table, Map<String, Object> attrs, Set<String> modifyFlag, StringBuilder sql, List<Object> paras) {
        sql.append("update ").append(table.getName()).append(" set ");
        String[] pKeys = table.getPrimaryKey();
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!modifyFlag.contains(colName) || this.isPrimaryKey(colName, pKeys) || !table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append(pKeys[i]).append(" = ?");
            paras.add(attrs.get(pKeys[i]));
        }
    }

    @Override
    public String forModelFindById(Table table, String columns) {
        StringBuilder sql = new StringBuilder("select ").append(columns).append(" from ");
        sql.append(table.getName());
        sql.append(" where ");
        String[] pKeys = table.getPrimaryKey();
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append(pKeys[i]).append(" = ?");
        }
        return sql.toString();
    }

    @Override
    public String forDbFindById(String tableName, String[] pKeys) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        StringBuilder sql = new StringBuilder("select * from ").append(tableName).append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append(pKeys[i]).append(" = ?");
        }
        return sql.toString();
    }

    @Override
    public String forDbDeleteById(String tableName, String[] pKeys) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append(pKeys[i]).append(" = ?");
        }
        return sql.toString();
    }

    @Override
    public void forDbSave(String tableName, String[] pKeys, Row record, StringBuilder sql, List<Object> paras) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        sql.append("insert into ");
        sql.append(tableName).append('(');
        StringBuilder temp = new StringBuilder();
        temp.append(") values(");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append(e.getKey());
            temp.append('?');
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(')');
    }

    @Override
    public void forDbUpdate(String tableName, String[] pKeys, Object[] ids, Row record, StringBuilder sql, List<Object> paras) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        Set<String> modifyFlag = CPI.getModifyFlag(record);
        sql.append("update ").append(tableName).append(" set ");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            String colName = e.getKey();
            if (!modifyFlag.contains(colName) || this.isPrimaryKey(colName, pKeys)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append(pKeys[i]).append(" = ?");
            paras.add(ids[i]);
        }
    }

    @Override
    public String forPaginate(int pageNumber, int pageSize, StringBuilder findSql) {
        throw new ActiveRecordException("Your should not invoke this method because takeOverDbPaginate(...) will take over it.");
    }

    @Override
    public boolean isTakeOverDbPaginate() {
        return true;
    }

    public Page<Row> takeOverDbPaginate(Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws SQLException {
        long totalRow;
        List result = CPI.query(conn, totalRowSql, paras);
        int size = result.size();
        if (isGroupBySql == null) {
            isGroupBySql = size > 1;
        }
        if (isGroupBySql.booleanValue()) {
            totalRow = size;
        } else {
            long l = totalRow = size > 0 ? ((Number)result.get(0)).longValue() : 0L;
        }
        if (totalRow == 0L) {
            return new Page(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        int totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        if (pageNumber > totalPage) {
            return new Page(new ArrayList(0), pageNumber, pageSize, totalPage, (int)totalRow);
        }
        PreparedStatement pst = conn.prepareStatement(findSql.toString(), 1003, 1007);
        for (int i = 0; i < paras.length; ++i) {
            pst.setObject(i + 1, paras[i]);
        }
        ResultSet rs = pst.executeQuery();
        int offset = pageSize * (pageNumber - 1);
        for (int i = 0; i < offset && rs.next(); ++i) {
        }
        List<Row> list = this.buildRecord(rs, pageSize);
        if (rs != null) {
            rs.close();
        }
        if (pst != null) {
            pst.close();
        }
        return new Page(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    private List<Row> buildRecord(ResultSet rs, int pageSize) throws SQLException {
        ArrayList<Row> result = new ArrayList<Row>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        for (int k = 0; k < pageSize && rs.next(); ++k) {
            Row record = new Row();
            Map<String, Object> columns = record.getColumns();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? ModelBuilder.me.handleClob(rs.getClob(i)) : (types[i] == 2011 ? ModelBuilder.me.handleClob(rs.getNClob(i)) : (types[i] == 2004 ? (Object)ModelBuilder.me.handleBlob(rs.getBlob(i)) : rs.getObject(i))));
                columns.put(labelNames[i], value);
            }
            result.add(record);
        }
        return result;
    }

    private void buildLabelNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }

    @Override
    public boolean isTakeOverModelPaginate() {
        return true;
    }

    public Page<? extends Model> takeOverModelPaginate(Connection conn, Class<? extends Model> modelClass, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws Exception {
        long totalRow;
        List result = CPI.query(conn, totalRowSql, paras);
        int size = result.size();
        if (isGroupBySql == null) {
            isGroupBySql = size > 1;
        }
        if (isGroupBySql.booleanValue()) {
            totalRow = size;
        } else {
            long l = totalRow = size > 0 ? ((Number)result.get(0)).longValue() : 0L;
        }
        if (totalRow == 0L) {
            return new Page(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        int totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        if (pageNumber > totalPage) {
            return new Page(new ArrayList(0), pageNumber, pageSize, totalPage, (int)totalRow);
        }
        PreparedStatement pst = conn.prepareStatement(findSql.toString(), 1003, 1007);
        for (int i = 0; i < paras.length; ++i) {
            pst.setObject(i + 1, paras[i]);
        }
        ResultSet rs = pst.executeQuery();
        int offset = pageSize * (pageNumber - 1);
        for (int i = 0; i < offset && rs.next(); ++i) {
        }
        List list = this.buildModel(rs, modelClass, pageSize);
        if (rs != null) {
            rs.close();
        }
        if (pst != null) {
            pst.close();
        }
        return new Page(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    public final <T> List<T> buildModel(ResultSet rs, Class<? extends Model> modelClass, int pageSize) throws SQLException, ReflectiveOperationException {
        ArrayList<Model> result = new ArrayList<Model>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        for (int k = 0; k < pageSize && rs.next(); ++k) {
            Model ar = modelClass.newInstance();
            Map<String, Object> attrs = CPI.getAttrs(ar);
            for (int i = 1; i <= columnCount; ++i) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? ModelBuilder.me.handleClob(rs.getClob(i)) : (types[i] == 2011 ? ModelBuilder.me.handleClob(rs.getNClob(i)) : (types[i] == 2004 ? (Object)ModelBuilder.me.handleBlob(rs.getBlob(i)) : rs.getObject(i))));
                attrs.put(labelNames[i], value);
            }
            result.add(ar);
        }
        return result;
    }

    @Override
    public void fillStatement(PreparedStatement pst, List<Object> paras) throws SQLException {
        int size = paras.size();
        for (int i = 0; i < size; ++i) {
            this.fillPst(pst, i, paras.get(i));
        }
    }

    @Override
    public void fillStatement(PreparedStatement pst, Object ... paras) throws SQLException {
        int size = paras.length;
        for (int i = 0; i < size; ++i) {
            this.fillPst(pst, i, paras[i]);
        }
    }

    @Override
    public String forDbFindColumnsById(String tableName, String columns, String[] pKeys) {
        return DialectUtils.forDbFindColumnsById(tableName, columns, pKeys);
    }

    @Override
    public String forDbFindColumns(String tableName, String columns) {
        return DialectUtils.forDbFindColumns(tableName, columns);
    }

    @Override
    public void forDbDelete(String tableName, String[] pKeys, Row record, StringBuilder sql, List<Object> paras) {
        DialectUtils.forDbDelete(tableName, pKeys, record, sql, paras);
    }

    @Override
    public String forExistsByFields(String tableName, String fields) {
        return DialectUtils.forExistsByFields(tableName, fields);
    }

    @Override
    public void forDbUpdate(String tableName, String[] pKeys, Object[] ids, Row record, StringBuilder sql, List<Object> paras, String[] jsonFields) {
        if (jsonFields != null) {
            for (String f : jsonFields) {
                record.set(f, Json.getJson().toJson(record.get(f)));
            }
        }
        this.forDbUpdate(tableName, pKeys, ids, record, sql, paras);
    }

    @Override
    public void transformJsonFields(Row record, String[] jsonFields) {
        if (jsonFields != null && jsonFields.length > 0) {
            for (String f : jsonFields) {
                Object object = record.get(f);
                if (object == null) continue;
                String value = Json.getJson().toJson(object);
                record.set(f, value);
            }
        }
    }

    @Override
    public void transformJsonFields(List<Row> recordList, String[] jsonFields) {
        if (jsonFields != null && jsonFields.length > 0) {
            for (String f : jsonFields) {
                for (Row record : recordList) {
                    Object object = record.get(f);
                    if (object == null) continue;
                    String value = Json.getJson().toJson(object);
                    record.set(f, value);
                }
            }
        }
    }

    @Override
    public StringBuffer forDbFind(String tableName, String columns, Row record, List<Object> paras) {
        StringBuffer sql = new StringBuffer();
        tableName = tableName.trim();
        sql.append("select ").append(columns).append(" from ").append(tableName);
        if (!record.getColumns().isEmpty()) {
            sql.append(" where ");
            boolean first = true;
            for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
                if (!first) {
                    sql.append(" and ");
                } else {
                    first = false;
                }
                sql.append(e.getKey()).append(" = ?");
                paras.add(e.getValue());
            }
        }
        return sql;
    }

    @Override
    public StringBuffer forDbFindByField(String tableName, String columns, String field, Object fieldValue, List<Object> paras) {
        StringBuffer sql = new StringBuffer();
        tableName = tableName.trim();
        sql.append("select ").append(columns).append(" from ").append(tableName);
        if (field != null && !field.isEmpty()) {
            sql.append(" where ");
            sql.append(field).append(" = ?");
            paras.add(fieldValue);
        }
        return sql;
    }

    @Override
    public String forColumns(String columns) {
        return DialectUtils.forColumns(columns);
    }

    @Override
    public void forDbSaveIfAbset(String tableName, String[] pKeys, Row record, StringBuilder sql, List<Object> paras) {
        throw new UnsupportedOperationException("AnsiSqlDialect does not support forDbSaveIfAbset. Use database-specific dialect like PostgreSqlDialect instead.");
    }
}

