/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.Row;
import com.litongjava.db.activerecord.builder.BuilderKit;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.postgresql.util.PGobject;

public class RecordBuilder {
    public static final RecordBuilder me = new RecordBuilder();

    public List<Row> build(Config config, ResultSet rs) throws SQLException {
        return this.build(config, rs, null);
    }

    public List<Row> buildJsonFields(Config config, ResultSet rs, String[] jsonFields) throws SQLException {
        return this.buildJsonFields(config, rs, jsonFields, null);
    }

    public List<Row> build(Config config, ResultSet rs, Function<Row, Boolean> func) throws SQLException {
        ArrayList<Row> result = new ArrayList<Row>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Row record = new Row();
            record.setColumnsMap(config.containerFactory.getColumnsMap());
            Map<String, Object> columns = record.getColumns();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = BuilderKit.getColumnValue(types, rs, i);
                columns.put(labelNames[i], value);
            }
            if (func == null) {
                result.add(record);
                continue;
            }
            if (func.apply(record).booleanValue()) continue;
            break;
        }
        return result;
    }

    public List<Row> buildJsonFields(Config config, ResultSet rs, String[] jsonFields, Function<Row, Boolean> func) throws SQLException {
        ArrayList<Row> result = new ArrayList<Row>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Row record = new Row();
            record.setColumnsMap(config.containerFactory.getColumnsMap());
            Map<String, Object> columns = record.getColumns();
            for (int i = 1; i <= columnCount; ++i) {
                String labelName = labelNames[i];
                Object value = BuilderKit.getColumnValue(types, rs, i);
                for (String jsonField : jsonFields) {
                    String stringValue;
                    if (!labelName.equals(jsonField) || value == null) continue;
                    if (value instanceof String) {
                        stringValue = (String)value;
                        value = BuilderKit.parseJsonField(stringValue);
                        continue;
                    }
                    if (!(value instanceof PGobject)) continue;
                    stringValue = ((PGobject)value).getValue();
                    value = BuilderKit.parseJsonField(stringValue);
                }
                columns.put(labelName, value);
            }
            if (func == null) {
                result.add(record);
                continue;
            }
            if (func.apply(record).booleanValue()) continue;
            break;
        }
        return result;
    }

    public void buildLabelNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }
}

