/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.wrapper.tio.boot;

import com.litongjava.context.BootConfiguration;
import com.litongjava.context.Context;
import com.litongjava.hotswap.kit.HotSwapUtils;
import com.litongjava.hotswap.watcher.HotSwapWatcher;
import com.litongjava.hotswap.wrapper.tio.boot.TioBootArgument;
import com.litongjava.hotswap.wrapper.tio.boot.TioBootRestartServer;
import com.litongjava.tio.boot.TioApplication;
import com.litongjava.tio.utils.environment.EnvUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioApplicationWrapper {
    private static final Logger log = LoggerFactory.getLogger(TioApplicationWrapper.class);
    protected static volatile HotSwapWatcher hotSwapWatcher;

    public static Context run(Class<?> primarySource, String[] args) {
        return TioApplicationWrapper.run(new Class[]{primarySource}, args);
    }

    public static Context run(Class<?> primarySource, BootConfiguration config, String[] args) {
        return TioApplicationWrapper.run(new Class[]{primarySource}, config, args);
    }

    private static Context run(Class<?>[] primarySources, String[] args) {
        return TioApplicationWrapper.run(primarySources, null, args);
    }

    private static Context run(Class<?>[] primarySources, BootConfiguration config, String[] args) {
        String mode = null;
        for (String arg : args) {
            String[] split = arg.split("=");
            if (!split[0].equals("--mode")) continue;
            mode = split[1];
            break;
        }
        if (mode == null) {
            mode = HotSwapUtils.isDevelopmentEnvironment() ? "dev" : "prod";
        }
        return TioApplicationWrapper.run(primarySources, args, config, "dev".equalsIgnoreCase(mode));
    }

    public static Context run(Class<?>[] primarySources, String[] args, BootConfiguration config, boolean isDev) {
        if (isDev) {
            return TioApplicationWrapper.runDev(primarySources, config, args);
        }
        return TioApplication.run((Class[])primarySources, (BootConfiguration)config, (String[])args);
    }

    public static Context runDev(Class<?>[] primarySources, BootConfiguration config, String[] args) {
        if (hotSwapWatcher == null) {
            hotSwapWatcher = new HotSwapWatcher(new TioBootRestartServer());
            log.info("start hotswap watcher:{}", (Object)hotSwapWatcher);
            hotSwapWatcher.start();
        }
        EnvUtils.set((String)"tio.core.hotswap.reload", (String)"true");
        ClassLoader hotSwapClassLoader = HotSwapUtils.getClassLoader();
        log.info("new hotswap class loader:{}", (Object)hotSwapClassLoader);
        Thread.currentThread().setContextClassLoader(hotSwapClassLoader);
        Context context = TioApplication.run((Class[])primarySources, (BootConfiguration)config, (String[])args);
        TioBootArgument.init(primarySources, config, args, context, true);
        return context;
    }
}

