/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.kit;

import com.litongjava.hotswap.kit.UndertowKit;
import java.io.File;
import java.net.URLDecoder;

public class PathKitExt {
    private static String locationPath = null;
    private static String rootClassPath = null;
    private static String webRootPath = null;

    public static String getLocationPath() {
        if (locationPath != null) {
            return locationPath;
        }
        try {
            Class<PathKitExt> clazz = PathKitExt.class;
            String path = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            path = URLDecoder.decode(path, "UTF-8");
            path = path.trim();
            File file = new File(path);
            if (file.isFile()) {
                path = file.getParent();
            }
            locationPath = path = PathKitExt.removeSlashEnd(path);
            return locationPath;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRootClassPath() {
        if (rootClassPath == null) {
            rootClassPath = PathKitExt.buildRootClassPath();
        }
        return rootClassPath;
    }

    private static String buildRootClassPath() {
        String classPathDirEndsWith_classes = PathKitExt.getClassPathDirEndsWith_classes();
        if (classPathDirEndsWith_classes != null) {
            return classPathDirEndsWith_classes;
        }
        String path = PathKitExt.getLocationPath();
        return PathKitExt.processRootClassPath(path);
    }

    private static String getClassPathDirEndsWith_classes() {
        String[] classPathDirs = UndertowKit.getClassPathDirs();
        if (classPathDirs == null || classPathDirs.length == 0) {
            return null;
        }
        for (String dir : classPathDirs) {
            if (dir == null || !(dir = PathKitExt.removeSlashEnd(dir.trim())).endsWith("classes")) continue;
            return dir;
        }
        return null;
    }

    private static String processRootClassPath(String path) {
        if (path.endsWith("classes")) {
            return path;
        }
        if (path.endsWith(File.separatorChar + "lib")) {
            path = path.substring(0, path.lastIndexOf(File.separatorChar));
        }
        return new File(path + File.separator + "config").getAbsolutePath();
    }

    public static String removeSlashEnd(String path) {
        if (path != null && path.endsWith(File.separator)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getWebRootPath() {
        if (webRootPath == null) {
            webRootPath = PathKitExt.buildWebRootPath();
        }
        return webRootPath;
    }

    private static String buildWebRootPath() {
        String classPathDirEndsWith_classes = PathKitExt.getClassPathDirEndsWith_classes();
        if (classPathDirEndsWith_classes != null) {
            return classPathDirEndsWith_classes;
        }
        String path = PathKitExt.getLocationPath();
        return PathKitExt.processWebRootPath(path);
    }

    private static String processWebRootPath(String path) {
        if (path.endsWith("classes")) {
            return path;
        }
        if (path.endsWith(File.separatorChar + "lib")) {
            path = path.substring(0, path.lastIndexOf(File.separatorChar));
        }
        return new File(path + File.separator + "webapp").getAbsolutePath();
    }

    public static void setWebRootPath(String webRootPath) {
        PathKitExt.webRootPath = webRootPath;
    }

    public static void setRootClassPath(String rootClassPath) {
        PathKitExt.rootClassPath = rootClassPath;
    }
}

