/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.kit;

import com.litongjava.hotswap.classloader.HotSwapClassLoader;
import com.litongjava.hotswap.kit.PathKitExt;
import com.litongjava.hotswap.watcher.HotSwapResolver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderKit {
    protected URL[] classPathUrls = this.buildClassPathUrls();
    protected ClassLoader parentClassLoader;
    protected HotSwapResolver hotSwapResolver;
    protected ClassLoader currentClassLoader;
    protected String configClassPathDirectory = null;

    public ClassLoaderKit(ClassLoader parentClassLoader, HotSwapResolver hotSwapResolver) {
        this.parentClassLoader = parentClassLoader;
        this.hotSwapResolver = hotSwapResolver;
        this.currentClassLoader = new HotSwapClassLoader(this.classPathUrls, parentClassLoader, hotSwapResolver);
    }

    public ClassLoader getClassLoader() {
        return this.currentClassLoader;
    }

    public ClassLoader replaceClassLoader() {
        this.currentClassLoader = new HotSwapClassLoader(this.classPathUrls, this.parentClassLoader, this.hotSwapResolver);
        return this.currentClassLoader;
    }

    protected URL[] buildClassPathUrls() {
        String[] classPathArray;
        ArrayList<URL> urlList = new ArrayList<URL>();
        this.addConfigClassPath(urlList);
        for (String classPath : classPathArray = System.getProperty("java.class.path").split(File.pathSeparator)) {
            File file;
            if (this.configClassPathDirectory != null && this.configClassPathDirectory.equals(classPath)) continue;
            if (classPath.startsWith("./")) {
                classPath = classPath.substring(2);
            }
            if (!(file = new File(classPath)).exists()) continue;
            try {
                urlList.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    protected void addConfigClassPath(List<URL> urlList) {
        String locationPath = PathKitExt.getLocationPath();
        this.addConfigClassPathDirectory(locationPath, urlList);
        if (urlList.size() > 0) {
            return;
        }
        int index = locationPath.lastIndexOf(File.separatorChar);
        String path = index > 0 ? locationPath.substring(0, index) : locationPath;
        this.addConfigClassPathDirectory(path, urlList);
    }

    private void addConfigClassPathDirectory(String path, List<URL> urlList) {
        File file = new File(path = path + File.separator + "config");
        if (file.exists() && file.isDirectory()) {
            try {
                urlList.add(file.toURI().toURL());
                this.configClassPathDirectory = path;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

