/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.hotswap.classloader;

import com.litongjava.hotswap.debug.Diagnostic;
import com.litongjava.hotswap.watcher.HotSwapResolver;
import java.net.URL;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotSwapClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(HotSwapClassLoader.class);
    final ClassLoader parent;
    protected HotSwapResolver hotSwapResolver;

    public HotSwapClassLoader(URL[] urls, ClassLoader parent, HotSwapResolver hotSwapResolver) {
        super(urls, parent);
        this.parent = parent;
        this.hotSwapResolver = hotSwapResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (Diagnostic.isDebug()) {
                log.info("isLoaded:{},{},", (Object)name, c);
            }
            if (c != null) {
                return c;
            }
            if (this.hotSwapResolver.isSystemClass(name)) {
                return this.parent.loadClass(name);
            }
            if (this.hotSwapResolver.isHotSwapClass(name)) {
                c = super.findClass(name);
                if (Diagnostic.isDebug()) {
                    log.info("findClass:{},{}", (Object)name, (Object)(c != null ? 1 : 0));
                }
                if (c != null) {
                    if (resolve) {
                        if (Diagnostic.isDebug()) {
                            log.info("resolveClass:{}", (Object)name);
                        }
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
            if (Diagnostic.isDebug()) {
                log.info("parent.loadClas:{},{}", (Object)this.parent.toString(), (Object)name);
            }
            return this.parent.loadClass(name);
        }
    }

    static {
        HotSwapClassLoader.registerAsParallelCapable();
    }
}

