/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PoiExcelUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Object> readFirstRow(byte[] excelBytes) {
        try (XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(excelBytes));){
            Sheet sheet = workbook.getSheetAt(0);
            Row row = sheet.getRow(0);
            ArrayList<Object> values = new ArrayList<Object>();
            if (row != null) {
                for (Cell cell : row) {
                    values.add(PoiExcelUtils.getCellValue(cell));
                }
            }
            ArrayList<Object> arrayList = values;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
            case BLANK: {
                return null;
            }
        }
        return cell.toString();
    }
}

