/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.litongjava.db.activerecord.Row;
import com.litongjava.kit.RowUtils;
import com.litongjava.table.convert.LocalDateTimeConverter;
import com.litongjava.table.convert.StringArrayConverter;
import com.litongjava.table.convert.TimestampStringConverter;
import com.litongjava.table.excel.MaxColumnWidthStyleStrategy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EasyExcelUtils {
    public static <T> void write(OutputStream outputStream, String filename, String sheetName, Class<T> head, List<T> data) throws IOException {
        if (head != null) {
            ((ExcelWriterSheetBuilder)EasyExcelUtils.getExcelWriteBuilder(outputStream).sheet(sheetName).head(head)).doWrite(data);
        } else {
            EasyExcelUtils.getExcelWriteBuilder(outputStream).sheet(sheetName).doWrite(data);
        }
    }

    public static void write(OutputStream outputStream, String sheetName, List<Row> records) {
        String[] columnNames = null;
        int size = records.size();
        if (size <= 0) {
            return;
        }
        Row record = records.get(0);
        columnNames = record.getColumnNames();
        List<List<String>> heads = EasyExcelUtils.head(columnNames);
        List columnValues = RowUtils.getListData(records, (int)size);
        ((ExcelWriterSheetBuilder)EasyExcelUtils.getExcelWriteBuilder(outputStream).sheet(sheetName).head(heads)).doWrite((Collection)columnValues);
    }

    public static void write(OutputStream outputStream, Map<String, List<Row>> allTableData) {
        ExcelWriterBuilder excelWriterBuilder = EasyExcelUtils.getExcelWriteBuilder(outputStream);
        ExcelWriter excelWriter = excelWriterBuilder.build();
        Set<String> sheetNames = allTableData.keySet();
        for (String sheetName : sheetNames) {
            List<Row> records = allTableData.get(sheetName);
            int listSize = records.size();
            String[] columnNames = null;
            if (listSize <= 0) continue;
            Row record = records.get(0);
            columnNames = record.getColumnNames();
            List<List<String>> heads = EasyExcelUtils.head(columnNames);
            List columnValues = RowUtils.getListData(records, (int)listSize);
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetName).head(heads)).build();
            excelWriter.write((Collection)columnValues, writeSheet);
        }
        excelWriter.finish();
    }

    public static ExcelWriterBuilder getExcelWriteBuilder(OutputStream outputStream) {
        ExcelWriterBuilder excelWriterBuilder = (ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream).autoCloseStream(Boolean.valueOf(false)).registerWriteHandler((WriteHandler)new MaxColumnWidthStyleStrategy(15, 30))).registerConverter((Converter)new LocalDateTimeConverter())).registerConverter((Converter)new TimestampStringConverter())).registerConverter((Converter)new StringArrayConverter());
        return excelWriterBuilder;
    }

    public static List<List<String>> head(String ... heads) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (String headString : heads) {
            ArrayList<String> head = new ArrayList<String>();
            head.add(headString);
            list.add(head);
        }
        return list;
    }
}

