/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.utils;

import com.litongjava.db.activerecord.Row;
import com.litongjava.table.utils.EasyExcelUtils;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.server.util.Resps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class EasyExcelResponseUtils {
    public static HttpResponse exportRecords(HttpResponse response, String filename, String sheetName, List<Row> records) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EasyExcelUtils.write(outputStream, sheetName, records);
        byte[] bytes = outputStream.toByteArray();
        Resps.bytesWithContentType((HttpResponse)response, (byte[])bytes, (String)"application/vnd.ms-excel;charset=UTF-8");
        String headeValue = "attachment;filename=";
        try {
            headeValue = headeValue + URLEncoder.encode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        response.addHeader("Content-Disposition", headeValue);
        return response;
    }

    public static HttpResponse exportAllTableRecords(HttpResponse response, String filename, LinkedHashMap<String, List<Row>> allTableData) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EasyExcelUtils.write(outputStream, allTableData);
        byte[] bytes = outputStream.toByteArray();
        Resps.bytesWithContentType((HttpResponse)response, (byte[])bytes, (String)"application/vnd.ms-excel;charset=UTF-8");
        String headeValue = "attachment;filename=";
        try {
            headeValue = headeValue + URLEncoder.encode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        response.addHeader("Content-Disposition", headeValue);
        return response;
    }

    public static <T> HttpResponse export(HttpResponse response, String filename, String sheetName, List<Row> records, Class<T> clazz) {
        List exportDatas = records.stream().map(e -> e.toBean(clazz)).collect(Collectors.toList());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            EasyExcelUtils.write(outputStream, filename, sheetName, clazz, exportDatas);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        byte[] bytes = outputStream.toByteArray();
        Resps.bytesWithContentType((HttpResponse)response, (byte[])bytes, (String)"application/vnd.ms-excel;charset=UTF-8");
        String headeValue = "attachment;filename=";
        try {
            headeValue = headeValue + URLEncoder.encode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e3) {
            throw new RuntimeException(e3);
        }
        response.addHeader("Content-Disposition", headeValue);
        return response;
    }
}

