/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.services;

import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.DbPro;
import com.litongjava.table.model.DbTableStruct;
import com.litongjava.table.services.DbService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PrimaryKeyService {
    private volatile Map<String, DbTableStruct> primaryKeys = new ConcurrentHashMap<String, DbTableStruct>();
    private DbService dbService = new DbService();

    public String getPrimaryKeyName(String tableName) {
        DbTableStruct primaryKey = this.getPrimaryKey(Db.use(), tableName);
        return primaryKey.getField();
    }

    public String getPrimaryKeyName(DbPro dbPro, String tableName) {
        DbTableStruct primaryKey = this.getPrimaryKey(dbPro, tableName);
        return primaryKey.getField();
    }

    public String getPrimaryKeyColumnType(String tableName) {
        DbTableStruct primaryKey = this.getPrimaryKey(Db.use(), tableName);
        return primaryKey.getType();
    }

    public String getPrimaryKeyColumnType(DbPro dbPro, String tableName) {
        DbTableStruct primaryKey = this.getPrimaryKey(dbPro, tableName);
        return primaryKey.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbTableStruct getPrimaryKey(DbPro dbPro, String tableName) {
        DbTableStruct primaryKey = this.primaryKeys.get(tableName);
        if (primaryKey == null) {
            DbService dbService = this.dbService;
            synchronized (dbService) {
                primaryKey = this.primaryKeys.get(tableName);
                if (primaryKey == null) {
                    primaryKey = this.dbService.getPrimaryKey(dbPro, tableName).get(0);
                    this.primaryKeys.put(tableName, primaryKey);
                }
            }
        }
        return primaryKey;
    }
}

