/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.services;

import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.litongjava.db.TableInput;
import com.litongjava.db.TableResult;
import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.DbPro;
import com.litongjava.db.activerecord.Row;
import com.litongjava.db.activerecord.dialect.Dialect;
import com.litongjava.db.activerecord.dialect.PostgreSqlDialect;
import com.litongjava.db.activerecord.dialect.TdEngineDialect;
import com.litongjava.db.utils.PgVectorUtils;
import com.litongjava.model.page.Page;
import com.litongjava.table.config.DbDataConfig;
import com.litongjava.table.model.DataPageRequest;
import com.litongjava.table.model.DataQueryRequest;
import com.litongjava.table.model.DbTableStruct;
import com.litongjava.table.model.Sql;
import com.litongjava.table.services.DbService;
import com.litongjava.table.services.DbSqlService;
import com.litongjava.table.services.DbTableService;
import com.litongjava.table.services.PrimaryKeyService;
import com.litongjava.table.services.TableColumnService;
import com.litongjava.table.utils.TableInputUtils;
import com.litongjava.tio.utils.UUIDUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.snowflake.SnowflakeIdUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.postgresql.util.PGobject;

public class ApiTable {
    private static DbSqlService dbSqlService = new DbSqlService();
    private static PrimaryKeyService primaryKeyService = new PrimaryKeyService();
    private static TableColumnService tableColumnService = new TableColumnService();
    private static DbTableService dbTableService = new DbTableService();
    private static DbService dbService = new DbService();
    private static Function<String, String> embeddingFun;

    public static void setEmbeddingFun(Function<String, String> embeddingFun) {
        ApiTable.embeddingFun = embeddingFun;
    }

    public static Function<String, String> getEmbeddingFun() {
        return embeddingFun;
    }

    public static TableResult<Kv> saveOrUpdate(String tableName, TableInput kv) {
        String[] jsonFields = TableInputUtils.getJsonFields(kv);
        return ApiTable.saveOrUpdate(tableName, kv, jsonFields);
    }

    public static TableResult<Kv> save(String tableName, TableInput kv) {
        String[] jsonFields = TableInputUtils.getJsonFields(kv);
        return ApiTable.save(tableName, kv, jsonFields);
    }

    public static TableResult<Kv> save(String tableName, TableInput kv, String[] jsonFields) {
        boolean save;
        String primaryKeyColumnType;
        TableInputUtils.removeEmptyValue(kv);
        TableInputUtils.true21(kv);
        Row record = new Row();
        record.setColumns((Map)kv);
        String primaryKeyName = primaryKeyService.getPrimaryKeyName(tableName);
        if (kv.get((Object)primaryKeyName) == null && !StrKit.isBlank((String)(primaryKeyColumnType = primaryKeyService.getPrimaryKeyColumnType(tableName)))) {
            if (primaryKeyColumnType.startsWith("varchar")) {
                String id = UUIDUtils.random();
                record.set(primaryKeyName, (Object)id);
            } else if (primaryKeyColumnType.startsWith("bigint") || primaryKeyColumnType.startsWith("long")) {
                long threadId = Thread.currentThread().getId();
                if (threadId > 31L) {
                    threadId %= 31L;
                }
                if (threadId < 0L) {
                    threadId = 0L;
                }
                long id = SnowflakeIdUtils.id();
                record.set(primaryKeyName, (Object)id);
            }
        }
        if (save = Db.save((String)tableName, (String)primaryKeyName, (Row)record, (String[])jsonFields)) {
            Kv by = Kv.by((Object)primaryKeyName, (Object)record.getObject(primaryKeyName));
            return new TableResult((Object)by);
        }
        return TableResult.fail((String)"save fail");
    }

    public static TableResult<Kv> saveOrUpdate(String tableName, TableInput kv, String[] jsonFields) {
        return ApiTable.saveOrUpdate(Db.use(), tableName, kv, jsonFields);
    }

    public static TableResult<Kv> saveOrUpdate(DbPro dbPro, String tableName, TableInput kv, String[] jsonFields) {
        TableInputUtils.true21(kv);
        Map<String, String> embeddingMap = TableInputUtils.getEmbeddingMap(kv);
        Row record = new Row();
        record.setColumns((Map)kv);
        Set<Map.Entry<String, String>> set = embeddingMap.entrySet();
        if (embeddingFun != null) {
            for (Map.Entry<String, String> e : set) {
                String key = e.getKey();
                String textValue = kv.getStr((Object)key);
                if (textValue == null || !(Db.use().getConfig().getDialect() instanceof PostgreSqlDialect)) continue;
                String embeddingArrayString = embeddingFun.apply(textValue);
                PGobject pgVector = PgVectorUtils.getPgVector((String)embeddingArrayString);
                record.set(e.getValue(), (Object)pgVector);
            }
        }
        String primaryKeyName = primaryKeyService.getPrimaryKeyName(dbPro, tableName);
        if (jsonFields == null) {
            jsonFields = dbService.getJsonField(dbPro, tableName);
        }
        if (kv.containsKey((Object)primaryKeyName)) {
            boolean save;
            String idValue = record.getStr(primaryKeyName);
            if (!StrKit.isBlank((String)idValue)) {
                boolean update = ApiTable.update(dbPro, tableName, primaryKeyName, idValue, record, jsonFields);
                if (update) {
                    return new TableResult();
                }
                return TableResult.fail();
            }
            Object id = ApiTable.getIdValueByType(dbPro, tableName);
            if (id != null) {
                record.set(primaryKeyName, id);
            }
            if (save = Db.save((String)tableName, (Row)record, (String[])jsonFields)) {
                Kv by = Kv.by((Object)primaryKeyName, (Object)record.getObject(primaryKeyName));
                return new TableResult((Object)by);
            }
            return TableResult.fail((String)"save fail");
        }
        boolean save = ApiTable.save(dbPro, tableName, jsonFields, primaryKeyName, record);
        if (save) {
            Kv by = Kv.by((Object)primaryKeyName, (Object)record.getObject(primaryKeyName));
            return new TableResult((Object)by);
        }
        return TableResult.fail((String)"save fail");
    }

    public static boolean save(String tableName, String[] jsonFields, String primaryKeyName, Row record) {
        return ApiTable.save(Db.use(), tableName, jsonFields, primaryKeyName, record);
    }

    public static boolean save(DbPro dbPro, String tableName, String[] jsonFields, String primaryKeyName, Row record) {
        Object id = ApiTable.getIdValueByType(dbPro, tableName);
        if (id != null) {
            record.set(primaryKeyName, id);
        }
        return dbPro.save(tableName, record, jsonFields);
    }

    public static Object getIdValueByType(DbPro dbPro, String tableName) {
        String primaryKeyColumnType = primaryKeyService.getPrimaryKeyColumnType(dbPro, tableName).toLowerCase();
        if (!StrKit.isBlank((String)primaryKeyColumnType)) {
            if (primaryKeyColumnType.startsWith("varchar") || primaryKeyColumnType.startsWith("text")) {
                return UUIDUtils.random();
            }
            if (primaryKeyColumnType.startsWith("bigint") || primaryKeyColumnType.startsWith("long")) {
                long threadId = Thread.currentThread().getId();
                if (threadId > 31L) {
                    threadId %= 31L;
                }
                if (threadId < 0L) {
                    threadId = 0L;
                }
                return SnowflakeIdUtils.id();
            }
        }
        return null;
    }

    public static boolean update(String tableName, String primaryKeyName, String idValue, Row record, String[] jsonFields) {
        return ApiTable.update(Db.use(), tableName, primaryKeyName, idValue, record, jsonFields);
    }

    public static boolean update(DbPro dbPro, String tableName, String primaryKeyName, String idValue, Row record, String[] jsonFields) {
        String primaryKeyColumnType = primaryKeyService.getPrimaryKeyColumnType(tableName);
        boolean update = false;
        if ("uuid".equals(primaryKeyColumnType)) {
            UUID idUUID = UUID.fromString(idValue);
            record.set(primaryKeyName, (Object)idUUID);
            update = dbPro.update(tableName, primaryKeyName, record, jsonFields);
        } else {
            update = dbPro.update(tableName, primaryKeyName, record, jsonFields);
        }
        return update;
    }

    public static boolean update(String tableName, String primaryKeyName, Object idValue, Row record) {
        String primaryKeyColumnType = primaryKeyService.getPrimaryKeyColumnType(tableName);
        boolean update = false;
        if ("uuid".equals(primaryKeyColumnType)) {
            UUID idUUID = UUID.fromString((String)idValue);
            record.set(primaryKeyName, (Object)idUUID);
            update = Db.update((String)tableName, (String)primaryKeyName, (Row)record);
        } else {
            record.set(primaryKeyName, idValue);
            update = Db.update((String)tableName, (String)primaryKeyName, (Row)record);
        }
        return update;
    }

    public static TableResult<Kv> batchUpdateByIds(String f, TableInput kv) {
        DbPro dbPro = Db.use();
        return ApiTable.batchUpdateByIds(dbPro, f, kv);
    }

    public static TableResult<Kv> batchUpdateByIds(DbPro dbPro, String tableName, TableInput kv) {
        Object[] ids = (Object[])kv.getAs((Object)"ids", (Object)new Object[0]);
        kv.remove((Object)"ids");
        DbTableStruct primaryKey = primaryKeyService.getPrimaryKey(dbPro, tableName);
        String primaryKeyName = primaryKey.getField();
        String type = primaryKey.getType();
        boolean isUuid = false;
        if (type != null && type.startsWith("uuid")) {
            isUuid = true;
        }
        ArrayList<Row> lists = new ArrayList<Row>();
        for (Object id : ids) {
            Row record = new Row();
            record.setColumns(kv.toMap());
            if (isUuid) {
                record.set(primaryKeyName, (Object)UUID.fromString((String)id));
            } else {
                record.set(primaryKeyName, id);
            }
            lists.add(record);
        }
        int[] results = dbPro.batchUpdate(tableName, lists, lists.size());
        return new TableResult((Object)Kv.by((Object)"data", (Object)results));
    }

    public static TableResult<Kv> saveOrUpdate(TableInput kv) {
        String tableName = (String)kv.remove((Object)"table_name");
        return ApiTable.saveOrUpdate(tableName, kv);
    }

    public static TableResult<List<Row>> listAll(String tableName) {
        DbPro dbPro = Db.useRead();
        return ApiTable.listAll(dbPro, tableName);
    }

    public static TableResult<List<Row>> listAll(String tableName, String jsonFields) {
        DbPro dbPro = Db.useRead();
        return ApiTable.listAll(dbPro, tableName, jsonFields);
    }

    public static TableResult<List<Row>> listAll(String f, TableInput kv) {
        DbPro dbPro = Db.useRead();
        return ApiTable.listAll(dbPro, f, kv);
    }

    public static TableResult<List<Row>> listAll(DbPro dbPro, String tableName) {
        List records = dbPro.find("select * from " + tableName);
        if (records.size() < 1) {
            List<DbTableStruct> columns = dbService.getTableStruct(dbPro, tableName);
            Row record = new Row();
            for (DbTableStruct struct : columns) {
                record.set(struct.getField(), null);
            }
            records.add(record);
        }
        return new TableResult((Object)records);
    }

    public static TableResult<List<Row>> listAll(DbPro dbPro, String tableName, String jsonFields) {
        List records = null;
        String sql = "select * from " + tableName;
        if (jsonFields != null) {
            String[] split = jsonFields.split(",");
            records = dbPro.findWithJsonField(sql, split, new Object[0]);
        } else {
            records = dbPro.find(sql);
        }
        if (records.size() < 1) {
            List<DbTableStruct> columns = dbService.getTableStruct(dbPro, tableName);
            Row record = new Row();
            for (DbTableStruct struct : columns) {
                record.set(struct.getField(), null);
            }
            records.add(record);
        }
        return new TableResult((Object)records);
    }

    public static TableResult<List<Row>> listAll(DbPro dbPro, String tableName, TableInput kv) {
        String[] jsonFields = TableInputUtils.getJsonFields(kv);
        String sql = "select * from " + tableName;
        List records = null;
        records = jsonFields != null ? dbPro.findWithJsonField(sql, jsonFields, new Object[0]) : dbPro.find(sql);
        if (records.size() < 1) {
            List<DbTableStruct> columns = dbService.getTableStruct(dbPro, tableName);
            Row record = new Row();
            for (DbTableStruct struct : columns) {
                record.set(struct.getField(), null);
            }
            records.add(record);
        }
        return new TableResult((Object)records);
    }

    public static TableResult<List<Row>> list(String tableName, TableInput tableInput) {
        return ApiTable.list(Db.useRead(), tableName, tableInput);
    }

    public static TableResult<List<Row>> list(DbPro dbPro, String tableName, TableInput tableInput) {
        DataQueryRequest queryRequest = new DataQueryRequest(tableInput);
        String[] jsonFields = TableInputUtils.getJsonFields(tableInput);
        Sql sql = dbSqlService.getWhereClause(dbPro, queryRequest, tableInput);
        sql.setColumns(dbPro.getConfig().getDialect().forColumns(queryRequest.getColumns()));
        sql.setTableName(tableName);
        List<Object> params = sql.getParams();
        List list = null;
        list = params == null ? (jsonFields != null ? dbPro.findWithJsonFields(sql.getsql(), jsonFields) : dbPro.find(sql.getsql())) : (jsonFields != null ? dbPro.findWithJsonField(sql.getsql(), jsonFields, sql.getParams().toArray()) : dbPro.find(sql.getsql(), sql.getParams().toArray()));
        return new TableResult((Object)list);
    }

    public static TableResult<Page<Row>> page(TableInput kv) {
        String tableName = (String)kv.remove((Object)"table_name");
        DataPageRequest dataPageRequest = new DataPageRequest(kv);
        return ApiTable.page(tableName, dataPageRequest, kv);
    }

    public static TableResult<Page<Row>> page(DbPro dbPro, TableInput kv) {
        String tableName = (String)kv.remove((Object)"table_name");
        DataPageRequest dataPageRequest = new DataPageRequest(kv);
        return ApiTable.page(dbPro, tableName, dataPageRequest, kv);
    }

    public static TableResult<Page<Row>> page(String tableName, TableInput kv) {
        DataPageRequest dataPageRequest = new DataPageRequest(kv);
        return ApiTable.page(tableName, dataPageRequest, kv);
    }

    public static TableResult<Page<Row>> page(String tableName) {
        TableInput kv = TableInput.create();
        DataPageRequest dataPageRequest = new DataPageRequest(kv);
        return ApiTable.page(tableName, dataPageRequest, kv);
    }

    public static TableResult<Page<Row>> page(DbPro dbPro, String f, TableInput kv) {
        kv.remove((Object)"table_name");
        DataPageRequest dataPageRequest = new DataPageRequest(kv);
        return ApiTable.page(dbPro, f, dataPageRequest, kv);
    }

    public static TableResult<Page<Row>> page(String tableName, DataPageRequest dataPageRequest, TableInput kv) {
        return ApiTable.page(Db.useRead(), tableName, dataPageRequest, kv);
    }

    public static TableResult<Page<Row>> page(DbPro dbPro, String tableName, DataPageRequest pageRequest, TableInput para) {
        DbTableStruct primaryKey;
        String primaryKeyName;
        Object idValue;
        Dialect dialect = dbPro.getConfig().getDialect();
        if (!(dialect instanceof TdEngineDialect) && (idValue = para.get((Object)(primaryKeyName = (primaryKey = primaryKeyService.getPrimaryKey(dbPro, tableName)).getField()))) != null && "uuid".equals(primaryKey.getType())) {
            UUID idUUID = UUID.fromString((String)idValue);
            para.set((Object)primaryKeyName, (Object)idUUID);
        }
        Integer pageNo = pageRequest.getPageNo();
        Integer pageSize = pageRequest.getPageSize();
        DataQueryRequest queryRequest = new DataQueryRequest(para);
        String[] jsonFields = TableInputUtils.getJsonFields(para);
        if (jsonFields == null) {
            jsonFields = dbService.getJsonField(dbPro, tableName);
        }
        Sql sql = dbSqlService.getWhereClause(dbPro, queryRequest, para);
        sql.setTableName(tableName);
        sql.setColumns(dbPro.getConfig().getDialect().forColumns(queryRequest.getColumns()));
        List<Object> params = sql.getParams();
        String sqlExceptSelect = sql.getSqlExceptSelect();
        Page listPage = null;
        listPage = params == null ? (jsonFields != null && jsonFields.length > 0 ? dbPro.paginateJsonFields(pageNo.intValue(), pageSize.intValue(), sql.getSelectColumns(), sqlExceptSelect, jsonFields) : dbPro.paginate(pageNo.intValue(), pageSize.intValue(), sql.getSelectColumns(), sqlExceptSelect)) : (jsonFields != null && jsonFields.length > 0 ? dbPro.paginateJsonFields(pageNo.intValue(), pageSize.intValue(), sql.getSelectColumns(), sqlExceptSelect, jsonFields, params.toArray()) : dbPro.paginate(pageNo.intValue(), pageSize.intValue(), sql.getSelectColumns(), sqlExceptSelect, params.toArray()));
        return new TableResult((Object)listPage);
    }

    public static TableResult<Row> get(String tableName, TableInput tableInput) {
        return ApiTable.get(Db.useRead(), tableName, tableInput);
    }

    public static TableResult<Row> get(DbPro dbPro, String tableName, TableInput tableInput) {
        DataQueryRequest queryRequest = new DataQueryRequest(tableInput);
        String[] jsonFields = TableInputUtils.getJsonFields(tableInput);
        Sql sql = dbSqlService.getWhereClause(dbPro, queryRequest, tableInput);
        sql.setTableName(tableName);
        sql.setColumns(dbPro.getConfig().getDialect().forColumns(queryRequest.getColumns()));
        Row record = null;
        List<Object> params = sql.getParams();
        record = jsonFields != null && jsonFields.length > 0 ? (params == null ? dbPro.findFirstJsonField(sql.getsql(), jsonFields, new Object[0]) : dbPro.findFirstJsonField(sql.getsql(), jsonFields, params.toArray())) : (params == null ? dbPro.findFirst(sql.getsql()) : dbPro.findFirst(sql.getsql(), params.toArray()));
        return new TableResult((Object)record);
    }

    public static TableResult<Row> getById(String tableName, Object idValue, TableInput tableInput) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        tableInput.put((Object)primaryKey, idValue);
        return ApiTable.get(tableName, tableInput);
    }

    public static TableResult<Row> getById(String tableName, Object idValue) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        TableInput tableInput = new TableInput();
        tableInput.set((Object)primaryKey, idValue);
        return ApiTable.get(Db.useRead(), tableName, tableInput);
    }

    public static TableResult<Boolean> delById(String tableName, Object value) {
        String key = primaryKeyService.getPrimaryKeyName(tableName);
        if (Db.deleteById((String)tableName, (String)key, (Object)(value = ApiTable.transformValueType(tableName, key, value)))) {
            return TableResult.ok();
        }
        return TableResult.fail();
    }

    public static TableResult<Boolean> delById(String tableName, Object id, String creatorColumn, Object creator) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        Row deleteRecord = Row.by((String)primaryKey, (Object)id).set(creatorColumn, creator);
        if (Db.delete((String)tableName, (Row)deleteRecord)) {
            return TableResult.ok();
        }
        return TableResult.fail();
    }

    public static TableResult<Boolean> delById(String tableName, String primayKey, Object id) {
        if (Db.deleteById((String)tableName, (String)primayKey, (Object)id)) {
            return TableResult.ok();
        }
        return TableResult.fail();
    }

    public static TableResult<Boolean> del(String tableName, TableInput tableInput) {
        DbPro use = Db.use();
        return ApiTable.del(use, tableName, tableInput);
    }

    private static TableResult<Boolean> del(DbPro dbPro, String tableName, TableInput tableInput) {
        return ApiTable.delete(dbPro, tableName, tableInput);
    }

    private static TableResult<Boolean> delete(DbPro dbPro, String tableName, TableInput tableInput) {
        DataQueryRequest queryRequest = new DataQueryRequest(tableInput);
        Sql sql = dbSqlService.getWhereClause(dbPro, queryRequest, tableInput);
        sql.setTableName(tableName);
        int delete = Db.delete((String)sql.getDelSql(), (Object[])sql.getParams().toArray());
        if (delete > 0) {
            return TableResult.ok();
        }
        return TableResult.fail();
    }

    public static TableResult<Boolean> delete(String tableName, TableInput tableInput) {
        DbPro use = Db.use();
        return ApiTable.delete(use, tableName, tableInput);
    }

    public static int[] deleteByIds(String tableName, List<?> ids) {
        DbPro use = Db.use();
        return ApiTable.deleteByIds(use, tableName, ids);
    }

    public static int[] deleteByIds(DbPro use, String tableName, List<?> ids) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        return ApiTable.deleteByIds(use, tableName, primaryKey, ids);
    }

    public static int[] deleteByIds(DbPro use, String tableName, String primaryKey, List<?> ids) {
        ArrayList<Row> records = new ArrayList<Row>();
        for (Object id : ids) {
            Row record = Row.by((String)primaryKey, id);
            records.add(record);
        }
        return use.batchDelete(tableName, records, 2000);
    }

    public static int[] deleteByIds(String tableName, String primaryKey, List<?> ids) {
        return ApiTable.deleteByIds(Db.use(), tableName, primaryKey, ids);
    }

    public static TableResult<Boolean> updateFlagById(String tableName, Object id, String delColumn, int flag) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        id = ApiTable.transformValueType(tableName, primaryKey, id);
        String updateSqlTemplate = "update %s set %s=%s where %s =?";
        String sql = String.format(updateSqlTemplate, tableName, delColumn, flag, primaryKey);
        int updateResult = Db.updateBySql((String)sql, (Object[])new Object[]{id});
        if (updateResult > 0) {
            return new TableResult();
        }
        return TableResult.fail((int)-1, (String)"update fail");
    }

    public static TableResult<Boolean> updateFlagById(String tableName, Object id, String delColumn, int flag, String creatorColumn, String creator) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        id = ApiTable.transformValueType(tableName, primaryKey, id);
        int updateResult = 0;
        if (creator != null) {
            String updateSqlTemplate = "update %s set %s=%s where %s =? and %s=?";
            String sql = String.format(updateSqlTemplate, tableName, delColumn, flag, primaryKey, creatorColumn);
            updateResult = Db.updateBySql((String)sql, (Object[])new Object[]{id, creator});
        } else {
            String updateSqlTemplate = "update %s set %s=%s where %s =?";
            String sql = String.format(updateSqlTemplate, tableName, delColumn, flag, primaryKey);
            updateResult = Db.updateBySql((String)sql, (Object[])new Object[]{id});
        }
        if (updateResult > 0) {
            return new TableResult();
        }
        return TableResult.fail((int)-1, (String)"update fail");
    }

    public static TableResult<Boolean> updateFlagByIdAndUserId(String tableName, Object id, String delColumn, int flag, String userIdColumn, String userId) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        id = ApiTable.transformValueType(tableName, primaryKey, id);
        String updateSqlTemplate = "UPDATE `%s` SET `%s` = ? WHERE `%s` = ? AND `%s` = ?";
        String sql = String.format(updateSqlTemplate, tableName, delColumn, primaryKey, userIdColumn);
        int updateResult = Db.updateBySql((String)sql, (Object[])new Object[]{flag, id, userId});
        if (updateResult > 0) {
            return new TableResult((Object)true);
        }
        return TableResult.fail((int)-1, (String)"update fail");
    }

    public static TableResult<Boolean> updateIsDelFlagById(String tableName, Object id) {
        String delFlagColumn = DbDataConfig.getDelColName();
        boolean isExists = tableColumnService.isExists(delFlagColumn, tableName);
        if (!isExists) {
            tableColumnService.addColumn(tableName, delFlagColumn, "int(1) unsigned DEFAULT 0 ", "\u662f\u5426\u5220\u9664,1\u5220\u9664,0\u672a\u5220\u9664");
        }
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        id = ApiTable.transformValueType(tableName, primaryKey, id);
        String upateTemplate = "update %s set is_del=1 where  %s =?";
        String sql = String.format(upateTemplate, tableName, primaryKey);
        int updateResult = Db.updateBySql((String)sql, (Object[])new Object[]{id});
        if (updateResult > 0) {
            return new TableResult();
        }
        return TableResult.fail((int)-1, (String)"update fail");
    }

    public static TableResult<Integer> removeByIds(String tableName, Kv kv) {
        int i;
        Set keySet = kv.keySet();
        int size = keySet.size();
        if (size < 1) {
            return null;
        }
        String key = null;
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String string;
            key = string = (String)iterator.next();
        }
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        String[] ids = ApiTable.getParaValues(key);
        boolean isNumeric = ApiTable.isNumeric(ids[0]);
        Object[] idValues = null;
        if (isNumeric) {
            idValues = new Integer[ids.length];
            for (i = 0; i < ids.length; ++i) {
                idValues[i] = Integer.parseInt(ids[i]);
            }
        } else {
            idValues = new String[ids.length];
            for (i = 0; i < ids.length; ++i) {
                idValues[i] = ids[i];
            }
        }
        StringBuffer where = new StringBuffer();
        for (int i2 = 0; i2 < idValues.length; ++i2) {
            if (i2 == idValues.length - 1) {
                where.append(primaryKey + "=?");
                continue;
            }
            where.append(primaryKey + "=? or ");
        }
        String sql = "update %s set is_del=1 where " + where.toString();
        sql = String.format(sql, tableName);
        Db.updateBySql((String)sql, (Object[])idValues);
        return new TableResult();
    }

    private static String[] getParaValues(String key) {
        return null;
    }

    private static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] getAllTableNames() {
        return dbService.tableNames();
    }

    public static TableResult<String[]> tableNames() {
        String[] allTableNames = dbService.tableNames();
        return new TableResult((Object)allTableNames);
    }

    public static TableResult<Map<String, Object>> tableConfig(String f, String tableName, String lang) {
        if (StrKit.isBlank((String)tableName)) {
            return new TableResult(-1, "tableName can't be empty");
        }
        return new TableResult(dbTableService.getTableConfig(f, tableName, lang));
    }

    public static TableResult<List<Row>> query(String sql) {
        List find = Db.find((String)sql);
        return new TableResult((Object)find);
    }

    public static TableResult<List<Row>> query(String sql, Object ... paras) {
        List find = null;
        find = paras == null || paras.length < 1 ? Db.find((String)sql) : Db.find((String)sql, (Object[])paras);
        return new TableResult((Object)find);
    }

    public static TableResult<List<Map<String, Object>>> columns(String f) {
        if (StrKit.isBlank((String)f)) {
            return new TableResult(-1, "tableName can't be empty");
        }
        return new TableResult(dbTableService.columns(f));
    }

    public static String queryStr(String tableName, Object idValue, TableInput ti) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        ti.set((Object)primaryKey, idValue);
        return ApiTable.queryStr(tableName, ti);
    }

    public static String queryStr(String tableName, TableInput ti) {
        return (String)ApiTable.query(Db.useRead(), tableName, ti);
    }

    public static Long queryLong(String tableName, Object idValue, TableInput ti) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        ti.set((Object)primaryKey, idValue);
        return ApiTable.queryLong(tableName, ti);
    }

    public static Long queryLong(String tableName, TableInput ti) {
        return (Long)ApiTable.query(Db.useRead(), tableName, ti);
    }

    public static PGobject queryPGobject(String tableName, Object idValue, TableInput ti) {
        String primaryKey = primaryKeyService.getPrimaryKeyName(tableName);
        ti.set((Object)primaryKey, idValue);
        return ApiTable.queryPGobject(tableName, ti);
    }

    public static PGobject queryPGobject(String tableName, TableInput ti) {
        return (PGobject)ApiTable.query(Db.useRead(), tableName, ti);
    }

    public static <T> T query(String tableName, TableInput ti) {
        return ApiTable.query(Db.useRead(), tableName, ti);
    }

    public static <T> T query(DbPro dbPro, String tableName, TableInput tableInput) {
        DataQueryRequest queryRequest = new DataQueryRequest(tableInput);
        Sql sql = dbSqlService.getWhereClause(dbPro, queryRequest, tableInput);
        sql.setTableName(tableName);
        sql.setColumns(dbPro.getConfig().getDialect().forColumns(queryRequest.getColumns()));
        List<Object> params = sql.getParams();
        if (params == null) {
            return (T)Db.queryFirst((String)sql.getsql());
        }
        return (T)Db.queryFirst((String)sql.getsql(), (Object[])params.toArray());
    }

    public static String getFieldType(String f, String key) {
        return dbTableService.getFieldType(f, key);
    }

    public static void transformType(String f, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String type;
            String key = entry.getKey();
            if ("pageNo".equals(key) || "pageSize".equals(key)) continue;
            Object value = entry.getValue();
            if (value instanceof String && StrUtil.isNotBlank((CharSequence)((String)value))) {
                BigDecimal amount;
                type = ApiTable.getFieldType(f, key);
                if (type == null) continue;
                if ("int".equals(type)) {
                    map.put(key, Integer.parseInt((String)value));
                    continue;
                }
                if ("short".equals(type)) {
                    map.put(key, Short.parseShort((String)value));
                    continue;
                }
                if ("long".equals(type)) {
                    map.put(key, Long.parseLong((String)value));
                    continue;
                }
                if ("date".equals(type)) {
                    if (!(value instanceof String)) continue;
                    map.put(key, Timestamp.valueOf((String)value));
                    continue;
                }
                if (!"numeric".equals(type)) continue;
                if (value instanceof String) {
                    amount = new BigDecimal((String)value);
                    map.put(key, amount);
                    continue;
                }
                if (value instanceof Number) {
                    amount = new BigDecimal(((Number)value).toString());
                    map.put(key, amount);
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                amount = (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
                map.put(key, amount);
                continue;
            }
            if (!(value instanceof Long) || !"date".equals(type = ApiTable.getFieldType(f, key))) continue;
            map.put(key, new Timestamp((Long)value));
        }
    }

    public static Object transformValueType(String tableName, String key, Object value) {
        if (value instanceof String && StrUtil.isNotBlank((CharSequence)((String)value))) {
            String type = ApiTable.getFieldType(tableName, key);
            if ("int".equals(type)) {
                value = Integer.parseInt((String)value);
            } else if ("short".equals(type)) {
                value = Short.parseShort((String)value);
            } else if ("long".equals(type)) {
                value = Long.parseLong((String)value);
            }
        }
        return value;
    }

    public static Long count(String tableName, TableInput tableInput) {
        return ApiTable.count(Db.useRead(), tableName, tableInput);
    }

    public static Long count(DbPro dbPro, String tableName, TableInput tableInput) {
        DataQueryRequest queryRequest = new DataQueryRequest(tableInput);
        Sql sql = dbSqlService.getWhereClause(dbPro, queryRequest, tableInput);
        sql.setColumns(dbPro.getConfig().getDialect().forColumns(queryRequest.getColumns()));
        sql.setTableName(tableName);
        List<Object> params = sql.getParams();
        if (params != null) {
            return dbPro.countBySql(sql.getsql(), params.toArray());
        }
        return dbPro.countBySql(sql.getsql(), new Object[0]);
    }
}

