/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.table.excel;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;

public class MaxColumnWidthStyleStrategy
extends AbstractColumnWidthStyleStrategy {
    private final int maxColumnWidth;
    private final int minColumnWidth;

    public MaxColumnWidthStyleStrategy(int minColumnWidth, int maxColumnWidth) {
        this.minColumnWidth = minColumnWidth;
        this.maxColumnWidth = maxColumnWidth;
    }

    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        Sheet sheet = writeSheetHolder.getSheet();
        int columnWidth = this.getCellDataLength(cell);
        if (columnWidth < this.minColumnWidth) {
            columnWidth = this.minColumnWidth;
        } else if (columnWidth > this.maxColumnWidth) {
            columnWidth = this.maxColumnWidth;
        }
        sheet.setColumnWidth(cell.getColumnIndex(), columnWidth * 256);
    }

    private int getCellDataLength(Cell cell) {
        if (cell == null) {
            return 0;
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue().getBytes().length;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue()).getBytes().length;
            }
            case NUMERIC: {
                return String.valueOf(cell.getNumericCellValue()).getBytes().length;
            }
        }
        return 0;
    }
}

