/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.enhance.buffer;

import com.litongjava.enhance.buffer.AbstractBufferPage;
import com.litongjava.enhance.buffer.DirectBufferCleaner;
import com.litongjava.enhance.buffer.VirtualBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class ElasticBufferPage
extends AbstractBufferPage {
    private final ConcurrentLinkedQueue<VirtualBuffer> cleanBuffers = new ConcurrentLinkedQueue();
    private final boolean direct;

    ElasticBufferPage(boolean direct) {
        this.direct = direct;
    }

    @Override
    public VirtualBuffer allocate(int size) {
        if (size == 0) {
            throw new UnsupportedOperationException("cannot allocate zero bytes");
        }
        this.idle = false;
        VirtualBuffer virtualBuffer = this.cleanBuffers.poll();
        if (virtualBuffer != null && virtualBuffer.getCapacity() == size) {
            virtualBuffer.buffer().clear();
            virtualBuffer.buffer(virtualBuffer.buffer());
            return virtualBuffer;
        }
        if (virtualBuffer != null) {
            this.clean0(virtualBuffer);
        }
        return new VirtualBuffer(this, this.direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size), 0, size);
    }

    @Override
    public void clean(VirtualBuffer cleanBuffer) {
        this.cleanBuffers.offer(cleanBuffer);
    }

    @Override
    public void tryClean() {
        if (!this.idle) {
            this.idle = true;
        } else {
            VirtualBuffer cleanBuffer;
            int count = 0;
            while (this.idle && count++ < 10 && (cleanBuffer = this.cleanBuffers.poll()) != null) {
                this.clean0(cleanBuffer);
            }
        }
    }

    private void clean0(VirtualBuffer virtualBuffer) {
        if (this.direct) {
            try {
                DirectBufferCleaner.clean(virtualBuffer.buffer());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void release() {
        if (this.direct) {
            VirtualBuffer virtualBuffer;
            while ((virtualBuffer = this.cleanBuffers.poll()) != null) {
                this.clean0(virtualBuffer);
            }
        }
    }

    public String toString() {
        return "BufferPage{direct=" + this.direct + " ,availableBuffers=" + this.cleanBuffers + '}';
    }
}

