/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.enhance.buffer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class DirectBufferCleaner {
    private static final int JAVA_MAJOR_VERSION = DirectBufferCleaner.getJavaMajorVersion();
    private static final Unsafe UNSAFE;
    private static final Method INVOKE_CLEANER_METHOD;

    public static void clean(ByteBuffer buffer) {
        if (JAVA_MAJOR_VERSION >= 9 && UNSAFE != null && INVOKE_CLEANER_METHOD != null) {
            try {
                INVOKE_CLEANER_METHOD.invoke((Object)UNSAFE, buffer);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to clean direct buffer", e);
            }
        } else {
            ((DirectBuffer)((Object)buffer)).cleaner().clean();
        }
    }

    private static int getJavaMajorVersion() {
        String version = System.getProperty("java.specification.version");
        if (version.startsWith("1.")) {
            return Integer.parseInt(version.substring(2));
        }
        return Integer.parseInt(version);
    }

    static {
        if (JAVA_MAJOR_VERSION >= 9) {
            Unsafe unsafe = null;
            Method invokeCleaner = null;
            try {
                Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                unsafe = (Unsafe)theUnsafeField.get(null);
                invokeCleaner = Unsafe.class.getMethod("invokeCleaner", ByteBuffer.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            UNSAFE = unsafe;
            INVOKE_CLEANER_METHOD = invokeCleaner;
        } else {
            UNSAFE = null;
            INVOKE_CLEANER_METHOD = null;
        }
    }
}

