/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.helpdesk.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.helpdesk.v1.model.ListAgentSkillRuleResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentSkillRule {
    private static final Logger log = LoggerFactory.getLogger(AgentSkillRule.class);
    private final Config config;

    public AgentSkillRule(Config config) {
        this.config = config;
    }

    public ListAgentSkillRuleResp list(RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_skill_rules", Sets.newHashSet(AccessTokenType.Tenant), null);
        ListAgentSkillRuleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAgentSkillRuleResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skill_rules", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        return resp;
    }

    public ListAgentSkillRuleResp list() throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/agent_skill_rules", Sets.newHashSet(AccessTokenType.Tenant), null);
        ListAgentSkillRuleResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAgentSkillRuleResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/agent_skill_rules", Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        return resp;
    }
}

