/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.quantity;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class XMedRControlChartUtil {
    public static BigDecimal calculateRChartCL(List<List<BigDecimal>> subgroupDataList) {
        if (subgroupDataList == null || subgroupDataList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        List subgroupRanges = subgroupDataList.stream().filter(subgroup -> subgroup != null && subgroup.size() >= 2).map(subgroup -> {
            BigDecimal minVal = subgroup.stream().min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
            BigDecimal maxVal = subgroup.stream().max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
            return maxVal.subtract(minVal);
        }).collect(Collectors.toList());
        if (subgroupRanges.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalRangeSum = subgroupRanges.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalRangeSum.divide(new BigDecimal(subgroupRanges.size()), MathContext.DECIMAL128);
    }

    public static BigDecimal calculateXMedChartCL(List<List<BigDecimal>> subgroupDataList) {
        if (subgroupDataList == null || subgroupDataList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        List subgroupMedians = subgroupDataList.stream().filter(subgroup -> subgroup != null && !subgroup.isEmpty()).map(subgroup -> {
            List sortedValues = subgroup.stream().sorted(BigDecimal::compareTo).collect(Collectors.toList());
            int subgroupSize = sortedValues.size();
            if (subgroupSize % 2 == 1) {
                return (BigDecimal)sortedValues.get(subgroupSize / 2);
            }
            BigDecimal middle1 = (BigDecimal)sortedValues.get(subgroupSize / 2 - 1);
            BigDecimal middle2 = (BigDecimal)sortedValues.get(subgroupSize / 2);
            return middle1.add(middle2).divide(new BigDecimal("2"), MathContext.DECIMAL128);
        }).collect(Collectors.toList());
        if (subgroupMedians.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalMedianSum = subgroupMedians.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalMedianSum.divide(new BigDecimal(subgroupMedians.size()), MathContext.DECIMAL128);
    }

    public static BigDecimal calculateXMedChartUCL(BigDecimal xMedTotalMedian, BigDecimal a2, BigDecimal rBar) {
        return xMedTotalMedian.add(a2.multiply(rBar));
    }

    public static BigDecimal calculateXMedChartLCL(BigDecimal xMedTotalMedian, BigDecimal a2, BigDecimal rBar) {
        BigDecimal lcl = xMedTotalMedian.subtract(a2.multiply(rBar));
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }

    public static BigDecimal calculateRChartUCL(BigDecimal d4, BigDecimal rBar) {
        return d4.multiply(rBar);
    }

    public static BigDecimal calculateRChartLCL(BigDecimal d3, BigDecimal rBar) {
        BigDecimal lcl = d3.multiply(rBar);
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }

    public static BigDecimal estimateProcessStdevByRBar(BigDecimal rBar, BigDecimal d2) {
        if (d2.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("Division by zero: d2 cannot be zero.");
        }
        return rBar.divide(d2, MathContext.DECIMAL128);
    }

    public static Number getMedian(List<BigDecimal> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            throw new IllegalArgumentException("\u8ba1\u7b97\u4e2d\u4f4d\u6570\u5931\u8d25\uff1a\u8f93\u5165\u5217\u8868\u4e3a\u7a7a\u6216null");
        }
        ArrayList<BigDecimal> sortedNumbers = new ArrayList<BigDecimal>(numbers);
        sortedNumbers.sort(Comparator.naturalOrder());
        int size = sortedNumbers.size();
        int midIndex = size / 2;
        if (size % 2 == 1) {
            return ((BigDecimal)sortedNumbers.get(midIndex)).doubleValue();
        }
        BigDecimal midLeft = (BigDecimal)sortedNumbers.get(midIndex - 1);
        BigDecimal midRight = (BigDecimal)sortedNumbers.get(midIndex);
        return midLeft.add(midRight).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP).doubleValue();
    }
}

