/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.measuresystemanalysis;

import com.jxdinfo.spc.formula.api.util.aviator.AviatorKit;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.measuresystemanalysis.dto.MsaTwoWayAnovaResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GageUtil {
    public static Number rUcl(final BigDecimal rBar, final BigDecimal d4) {
        return AviatorKit.execute("D4 * rBar", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("rBar", rBar);
                this.put("D4", d4);
            }
        });
    }

    public static Number rLcl(final BigDecimal rBar, final BigDecimal d3) {
        return d3.equals("0.000") ? new BigDecimal("0.000") : AviatorKit.execute("D3 * rBar", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("rBar", rBar);
                this.put("D3", d3);
            }
        });
    }

    public static Number xUcl(final BigDecimal xBar, final BigDecimal a2, final BigDecimal rBar) {
        return AviatorKit.execute("xBar + A2 * rBar", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("xBar", xBar);
                this.put("A2", a2);
                this.put("rBar", rBar);
            }
        });
    }

    public static Number xLcl(final BigDecimal xBar, final BigDecimal a2, final BigDecimal rBar) {
        return AviatorKit.execute("xBar - A2 * rBar", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("xBar", xBar);
                this.put("A2", a2);
                this.put("rBar", rBar);
            }
        });
    }

    public static Number varianceComponent(final BigDecimal ms, final BigDecimal batchMs, final BigDecimal repetitions) {
        return AviatorKit.execute("(ms - batchMs) / repetitions", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("ms", ms);
                this.put("batchMs", batchMs);
                this.put("repetitions", repetitions);
            }
        });
    }

    public static List<MsaTwoWayAnovaResult> msaTwoWayAnova(BigDecimal testerSs, BigDecimal batchSs, BigDecimal repetitionSs, BigDecimal error, BigDecimal repetitionsForSample, BigDecimal batchNum, String spec) {
        ArrayList<MsaTwoWayAnovaResult> twoWayANOVATable = new ArrayList<MsaTwoWayAnovaResult>();
        MsaTwoWayAnovaResult part = new MsaTwoWayAnovaResult();
        part.setResource("operator");
        MsaTwoWayAnovaResult operator = new MsaTwoWayAnovaResult();
        operator.setResource("part");
        MsaTwoWayAnovaResult repeatability = new MsaTwoWayAnovaResult();
        repeatability.setResource("repeatability");
        MsaTwoWayAnovaResult total = new MsaTwoWayAnovaResult();
        total.setResource("total");
        BigDecimal operatorDf = repetitionsForSample.subtract(BigDecimal.ONE);
        operator.setDf(StringUtils.isEmpty((CharSequence)spec) ? "" : operatorDf.toPlainString());
        GageUtil.handleTwoWayANOVATableElement(operator, testerSs, spec);
        BigDecimal partDf = batchNum.subtract(BigDecimal.ONE).subtract(operatorDf);
        part.setDf(StringUtils.isEmpty((CharSequence)spec) ? "" : partDf.toPlainString());
        GageUtil.handleTwoWayANOVATableElement(part, batchSs, spec);
        BigDecimal repeatabilityDf = batchNum.multiply(error).multiply(repetitionsForSample.subtract(BigDecimal.ONE));
        repeatability.setDf(StringUtils.isEmpty((CharSequence)spec) ? "" : repeatabilityDf.toPlainString());
        GageUtil.handleTwoWayANOVATableElement(repeatability, repetitionSs, spec);
        BigDecimal totalDf = batchNum.multiply(error).multiply(repetitionsForSample).subtract(BigDecimal.ONE);
        total.setDf(StringUtils.isEmpty((CharSequence)spec) ? "" : totalDf.toPlainString());
        BigDecimal totalSs = Calc.getBigDecimal(part.getSs()).add(Calc.getBigDecimal(repeatability.getSs())).add(Calc.getBigDecimal(operator.getSs()));
        total.setSs(StringUtils.isEmpty((CharSequence)spec) ? "" : Calc.tidyDecimal(totalSs, 7, true).toPlainString());
        BigDecimal partF = Calc.getBigDecimal(part.getMs()).divide(Calc.getBigDecimal(repeatability.getMs()), 20, RoundingMode.HALF_UP);
        part.setfValue(StringUtils.isEmpty((CharSequence)spec) ? "" : Calc.tidyDecimal(partF, 3, true).toPlainString());
        BigDecimal operatorF = Calc.getBigDecimal(operator.getMs()).divide(Calc.getBigDecimal(part.getMs()), 20, RoundingMode.HALF_UP);
        operator.setfValue(Calc.tidyDecimal(operatorF, 3, true).toPlainString());
        twoWayANOVATable.add(part);
        twoWayANOVATable.add(operator);
        twoWayANOVATable.add(repeatability);
        twoWayANOVATable.add(total);
        return twoWayANOVATable;
    }

    private static void handleTwoWayANOVATableElement(MsaTwoWayAnovaResult map, BigDecimal Ss, String spec) {
        BigDecimal partSs = Calc.tidyDecimal(Ss, 7, true);
        map.setSs(partSs.toPlainString());
        BigDecimal partMs = Calc.tidyDecimal(partSs.divide(Calc.getBigDecimal(map.getDf()), 20, RoundingMode.HALF_UP), 7, true);
        map.setMs(StringUtils.isEmpty((CharSequence)spec) ? "" : partMs.toPlainString());
    }
}

