/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.counting;

import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public class UChartUtils {
    public static BigDecimal calculateUBar(List<Integer> cList, List<Integer> nList) {
        BigDecimal totalC = cList.stream().map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalUnits = nList.stream().map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalC.divide(totalUnits, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateSigmaList(BigDecimal uBar, BigDecimal n) {
        BigDecimal variance = uBar.divide(n, MathContext.DECIMAL128);
        return CommonUtil.sqrt(variance, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateUCLList(BigDecimal cl, BigDecimal sigma) {
        return cl.add(sigma.multiply(new BigDecimal("3")));
    }

    public static BigDecimal calculateLCLList(BigDecimal cl, BigDecimal sigma) {
        BigDecimal lcl = cl.subtract(sigma.multiply(new BigDecimal("3")));
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }
}

