/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.counting;

import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public class NPChartUtils {
    public static BigDecimal calculateNPBar(List<Integer> npList) {
        BigDecimal totalNP = npList.stream().map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalNP.divide(BigDecimal.valueOf(npList.size()), MathContext.DECIMAL128);
    }

    public static BigDecimal calculateCL(BigDecimal pBar, Integer n) {
        return BigDecimal.valueOf(n.intValue()).multiply(pBar, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateSigma(BigDecimal pBar, Integer n) {
        BigDecimal oneMinusPBar = BigDecimal.ONE.subtract(pBar.divide(BigDecimal.valueOf(n.intValue()), MathContext.DECIMAL128));
        BigDecimal variance = pBar.multiply(oneMinusPBar, MathContext.DECIMAL128);
        return CommonUtil.sqrt(variance, MathContext.DECIMAL128);
    }

    public static BigDecimal calculateUCL(BigDecimal cl, BigDecimal sigma, Integer n) {
        BigDecimal ucl = cl.add(sigma.multiply(new BigDecimal("3")));
        return ucl.compareTo(BigDecimal.valueOf(n.intValue())) > 0 ? BigDecimal.valueOf(n.intValue()) : ucl;
    }

    public static BigDecimal calculateLCL(BigDecimal cl, BigDecimal sigma) {
        BigDecimal lcl = cl.subtract(sigma.multiply(new BigDecimal("3")));
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }
}

