/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.aviator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;

public class Calc {
    private BigDecimal value;
    private int scale = 20;
    private static final String TYPE_NOT_SUPPORT_MSG = "Calc\u63a5\u6536\u5230\u4e86\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b!";

    public Calc() {
        this.value = new BigDecimal("0");
    }

    public Calc(Number value) {
        this.value = new BigDecimal(value.toString());
    }

    public Calc(BigDecimal value) {
        this.value = value;
    }

    public Calc(String value) {
        this.value = new BigDecimal(value);
    }

    public Calc(Object value) {
        this.value = new BigDecimal(value.toString());
    }

    public Calc setScale(int scale) {
        this.scale = scale;
        return this;
    }

    public static BigDecimal getBigDecimal(Object val) {
        if (val instanceof String) {
            return new BigDecimal((String)val);
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString());
        }
        if (val instanceof Calc) {
            return ((Calc)val).value;
        }
        throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
    }

    public static BigDecimal tidyDecimal(BigDecimal number, Integer maxDecimals, Boolean isFittingZero) {
        maxDecimals = maxDecimals != null ? maxDecimals : 4;
        BigDecimal stripped = number.stripTrailingZeros();
        if (stripped.scale() > maxDecimals) {
            BigDecimal result = stripped.setScale((int)maxDecimals, RoundingMode.HALF_UP);
            return Boolean.FALSE.equals(isFittingZero) ? result.stripTrailingZeros() : result;
        }
        return Boolean.TRUE.equals(isFittingZero) ? stripped.setScale((int)maxDecimals, RoundingMode.HALF_UP) : stripped;
    }

    public Calc add(Object val) {
        if (val instanceof Number || val instanceof String || val instanceof Calc) {
            this.value = this.value.add(Calc.getBigDecimal(val));
        } else if (val instanceof Collection) {
            Collection value = (Collection)val;
            for (Object oneVal : value) {
                this.add(oneVal);
            }
        } else {
            throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
        }
        return this;
    }

    public Calc sub(Object val) {
        if (val instanceof Number || val instanceof String || val instanceof Calc) {
            this.value = this.value.subtract(Calc.getBigDecimal(val));
        } else if (val instanceof Collection) {
            Collection value = (Collection)val;
            for (Object oneVal : value) {
                this.sub(oneVal);
            }
        } else {
            throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
        }
        return this;
    }

    public Calc multiply(Object val) {
        if (val instanceof Number || val instanceof String || val instanceof Calc) {
            this.value = this.value.multiply(Calc.getBigDecimal(val));
        } else if (val instanceof Collection) {
            Collection value = (Collection)val;
            for (Object oneVal : value) {
                this.multiply(oneVal);
            }
        } else {
            throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
        }
        return this;
    }

    public Calc divide(Object val) {
        if (val instanceof Number || val instanceof String || val instanceof Calc) {
            this.value = this.value.divide(Calc.getBigDecimal(val), this.scale, RoundingMode.DOWN);
        } else if (val instanceof Collection) {
            Collection value = (Collection)val;
            for (Object oneVal : value) {
                this.divide(oneVal);
            }
        } else {
            throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
        }
        return this;
    }

    public Calc abs(Object val) {
        if (!(val instanceof Number || val instanceof String || val instanceof Calc)) {
            throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
        }
        this.value = Calc.getBigDecimal(val).abs();
        return this;
    }

    public Calc mod(Object val) {
        if (val instanceof Collection) {
            Object[] array = ((Collection)val).toArray();
            this.value = array.length == 2 ? Calc.getBigDecimal(array[0]).remainder(Calc.getBigDecimal(array[1])) : Calc.getBigDecimal(0);
        } else {
            throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
        }
        return this;
    }

    public Calc pow(Object val) {
        if (val instanceof Collection) {
            Object[] array = ((Collection)val).toArray();
            this.value = array.length == 2 ? Calc.getBigDecimal(Math.pow(Calc.getBigDecimal(array[0]).doubleValue(), Calc.getBigDecimal(array[1]).doubleValue())) : Calc.getBigDecimal(0);
        } else if (val instanceof Number || val instanceof String || val instanceof Calc) {
            this.value = Calc.getBigDecimal(Math.pow(Calc.getBigDecimal(this).doubleValue(), Calc.getBigDecimal(val).doubleValue()));
        } else {
            throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
        }
        return this;
    }

    public Calc log(Object val) {
        if (val instanceof Collection) {
            Object[] array = ((Collection)val).toArray();
            if (array.length == 2) {
                double base = Double.parseDouble(array[0].toString());
                double number = Double.parseDouble(array[1].toString());
                double result = Math.log(base) / Math.log(number);
                this.value = Calc.getBigDecimal(result);
            } else {
                this.value = Calc.getBigDecimal(0);
            }
        } else {
            throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
        }
        return this;
    }

    public Calc sqrt(Object val) {
        if (!(val instanceof Number || val instanceof String || val instanceof Calc)) {
            throw new RuntimeException(TYPE_NOT_SUPPORT_MSG);
        }
        double base = Double.parseDouble(val.toString());
        this.value = Calc.getBigDecimal(Math.exp(0.5 * Math.log(base)));
        return this;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public BigDecimal getScaledValue() {
        return this.value.setScale(this.scale, RoundingMode.HALF_DOWN);
    }

    public BigDecimal getScaledValue(RoundingMode roundingMode) {
        return this.value.setScale(this.scale, roundingMode);
    }

    public BigDecimal getValue(int scale) {
        return this.value.setScale(scale, RoundingMode.HALF_DOWN);
    }

    public BigDecimal getValue(int scale, RoundingMode roundingMode) {
        return this.value.setScale(scale, roundingMode);
    }

    public String toString() {
        return this.value.toString();
    }
}

