/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.quantity;

import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.quantity.BinomialProbabilityUtil;
import com.jxdinfo.spc.formula.api.util.quantity.entity.FittingNormalPoint;
import com.jxdinfo.spc.formula.api.util.quantity.entity.NormalPlotResult;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.NormalDistribution;

public class FittingNormalUtil {
    private static final MathContext MC = MathContext.DECIMAL128;
    private static final double SQRT_2PI = Math.sqrt(Math.PI * 2);
    private static final double P = 0.2316419;
    private static final double A1 = 0.31938153;
    private static final double A2 = -0.356563782;
    private static final double A3 = 1.781477937;
    private static final double A4 = -1.821255978;
    private static final double A5 = 1.330274429;

    public static BigDecimal calculateADStat(List<BigDecimal> data, BigDecimal mean, BigDecimal stdDev) {
        if (data == null || data.isEmpty() || data.size() < 3) {
            throw new RuntimeException("\u6837\u672c\u91cf\u9700\u22653\u624d\u80fd\u8fdb\u884cAD\u68c0\u9a8c");
        }
        if (stdDev.compareTo(BigDecimal.ZERO) == 0) {
            throw new RuntimeException("\u6807\u51c6\u5dee\u4e3a0\uff0c\u65e0\u6cd5\u8ba1\u7b97Z\u5206\u6570");
        }
        NormalDistribution normalDistribution = new NormalDistribution();
        ArrayList<BigDecimal> sortedData = new ArrayList<BigDecimal>(data);
        Collections.sort(sortedData);
        int n = sortedData.size();
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double y_i = ((BigDecimal)sortedData.get(i)).doubleValue();
            double y_rev = ((BigDecimal)sortedData.get(n - 1 - i)).doubleValue();
            double z_i = (y_i - mean.doubleValue()) / stdDev.doubleValue();
            double F_y_i = normalDistribution.cumulativeProbability(z_i);
            double z_rev = (y_rev - mean.doubleValue()) / stdDev.doubleValue();
            double F_y_rev = normalDistribution.cumulativeProbability(z_rev);
            int term = 2 * (i + 1) - 1;
            sum += (double)term * (Math.log(F_y_i) + Math.log(1.0 - F_y_rev));
        }
        return Calc.getBigDecimal((double)(-n) - sum / (double)n);
    }

    public static BigDecimal estimatePValue(BigDecimal adStat, int N) {
        double a2Prime = adStat.doubleValue() * (1.0 + 0.75 / (double)N + 2.25 / Math.pow(N, 2.0));
        if (a2Prime >= 13.0) {
            return BigDecimal.ZERO;
        }
        if (a2Prime > 0.6) {
            double term = 1.2937 - 5.709 * a2Prime + 0.0186 * Math.pow(a2Prime, 2.0);
            return Calc.getBigDecimal(Math.exp(term));
        }
        if (a2Prime > 0.34) {
            double term = 0.9177 - 4.279 * a2Prime - 1.38 * Math.pow(a2Prime, 2.0);
            return Calc.getBigDecimal(Math.exp(term));
        }
        if (a2Prime > 0.2) {
            double term = -8.318 + 42.796 * a2Prime - 59.938 * Math.pow(a2Prime, 2.0);
            return Calc.getBigDecimal(1.0 - Math.exp(term));
        }
        double term = -13.436 + 101.14 * a2Prime - 223.73 * Math.pow(a2Prime, 2.0);
        return Calc.getBigDecimal(1.0 - Math.exp(term));
    }

    public static NormalPlotResult calculateNormalPlotData(List<BigDecimal> data, BigDecimal calculatedMean, BigDecimal calculatedStdDev, int decimalNum) {
        if (data == null || data.size() < 2) {
            throw new RuntimeException("\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u81f3\u5c11\u9700\u89812\u4e2a\u6570\u636e\u70b9\u3002");
        }
        ArrayList<BigDecimal> sortedData = new ArrayList<BigDecimal>(data);
        Collections.sort(sortedData);
        int n = sortedData.size();
        List<FittingNormalPoint> plotPoints = FittingNormalUtil.calculatePlotPoints(sortedData, n, decimalNum);
        List<BigDecimal> xAxisData = plotPoints.stream().map(FittingNormalPoint::getX).collect(Collectors.toList());
        List<BigDecimal> yAxisData = plotPoints.stream().map(FittingNormalPoint::getY).collect(Collectors.toList());
        return new NormalPlotResult(xAxisData, yAxisData, null);
    }

    private static List<FittingNormalPoint> calculatePlotPoints(List<BigDecimal> data, int n, int decimalNum) {
        ArrayList<FittingNormalPoint> points = new ArrayList<FittingNormalPoint>();
        NormalDistribution standardNormal = new NormalDistribution(0.0, 1.0);
        for (int i = 0; i < n; ++i) {
            int rank = i + 1;
            BigDecimal x = data.get(i);
            BigDecimal p = BigDecimal.valueOf((double)rank - 0.3).divide(BigDecimal.valueOf((double)n + 0.4), 10, RoundingMode.HALF_UP);
            BigDecimal theoreticalZ = BigDecimal.valueOf(standardNormal.inverseCumulativeProbability(p.doubleValue()));
            points.add(new FittingNormalPoint(Calc.tidyDecimal(x, decimalNum, true), theoreticalZ, Calc.tidyDecimal(p.multiply(BigDecimal.valueOf(100L)), decimalNum, true)));
        }
        return points;
    }

    public static NormalPlotResult calculateRegressionParams(BigDecimal mean, BigDecimal stdDev, int decimalNum) {
        ArrayList<BigDecimal> xList = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> yList = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> zList = new ArrayList<BigDecimal>();
        for (int i = 1; i < 100; ++i) {
            double zScore = BinomialProbabilityUtil.calculateZScore((double)i / 100.0);
            xList.add(Calc.tidyDecimal(Calc.getBigDecimal(mean.doubleValue() + stdDev.doubleValue() * zScore), decimalNum, true));
            yList.add(new BigDecimal(i));
            zList.add(Calc.tidyDecimal(Calc.getBigDecimal(FittingNormalUtil.standardNormalCdf(zScore) * 100.0), decimalNum, true));
        }
        return new NormalPlotResult(xList, yList, zList);
    }

    public static double standardNormalCdf(double z) {
        if (z == 0.0) {
            return 0.5;
        }
        if (z < 0.0) {
            return 1.0 - FittingNormalUtil.standardNormalCdf(-z);
        }
        double t = 1.0 / (1.0 + 0.2316419 * z);
        double polynomial = 0.31938153 * t + -0.356563782 * t * t + 1.781477937 * t * t * t + -1.821255978 * Math.pow(t, 4.0) + 1.330274429 * Math.pow(t, 5.0);
        double exponent = Math.exp(-0.5 * z * z);
        return 1.0 - exponent / SQRT_2PI * polynomial;
    }

    public static BigDecimal standardNormalCdf(BigDecimal z, MathContext mc) {
        boolean isNegative;
        if (z.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal("0.5", mc);
        }
        BigDecimal zVal = new BigDecimal(z.toString(), mc);
        boolean bl = isNegative = zVal.compareTo(BigDecimal.ZERO) < 0;
        if (isNegative) {
            zVal = zVal.negate(mc);
        }
        BigDecimal pBig = new BigDecimal(String.valueOf(0.2316419), mc);
        BigDecimal one = BigDecimal.ONE;
        BigDecimal denominator = one.add(pBig.multiply(zVal, mc), mc);
        BigDecimal t = one.divide(denominator, mc);
        BigDecimal t2 = t.multiply(t, mc);
        BigDecimal t3 = t2.multiply(t, mc);
        BigDecimal t4 = t3.multiply(t, mc);
        BigDecimal t5 = t4.multiply(t, mc);
        BigDecimal a1Big = new BigDecimal(String.valueOf(0.31938153), mc);
        BigDecimal a2Big = new BigDecimal(String.valueOf(-0.356563782), mc);
        BigDecimal a3Big = new BigDecimal(String.valueOf(1.781477937), mc);
        BigDecimal a4Big = new BigDecimal(String.valueOf(-1.821255978), mc);
        BigDecimal a5Big = new BigDecimal(String.valueOf(1.330274429), mc);
        BigDecimal polynomial = a1Big.multiply(t, mc).add(a2Big.multiply(t2, mc), mc).add(a3Big.multiply(t3, mc), mc).add(a4Big.multiply(t4, mc), mc).add(a5Big.multiply(t5, mc), mc);
        BigDecimal zSquared = zVal.multiply(zVal, mc);
        BigDecimal halfZSquared = zSquared.divide(new BigDecimal("2", mc), mc);
        BigDecimal exponent = new BigDecimal(Math.exp(halfZSquared.negate().doubleValue()), mc);
        BigDecimal sqrt2PiBig = new BigDecimal(String.valueOf(SQRT_2PI), mc);
        BigDecimal oneOverSqrt2Pi = one.divide(sqrt2PiBig, mc);
        BigDecimal term = exponent.multiply(oneOverSqrt2Pi, mc).multiply(polynomial, mc);
        BigDecimal phi = one.subtract(term, mc);
        if (isNegative) {
            phi = one.subtract(phi, mc);
        }
        return phi;
    }
}

