/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.quantity;

import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import com.jxdinfo.spc.formula.api.util.quantity.entity.BinomialPoint;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.stat.regression.SimpleRegression;

public class BinomialProbabilityUtil {
    private static final MathContext MC = MathContext.DECIMAL128;

    public static double calculateNBar(List<Integer> detectNodeList) {
        int totalSampleSize = detectNodeList.stream().mapToInt(Integer::intValue).sum();
        return (double)totalSampleSize / (double)detectNodeList.size();
    }

    public static BigDecimal calculatePBar(List<Integer> failDataList, List<Integer> detectNodeList) {
        long totalFailures = 0L;
        long totalSamples = 0L;
        for (int i = 0; i < failDataList.size(); ++i) {
            totalFailures += (long)failDataList.get(i).intValue();
            totalSamples += (long)detectNodeList.get(i).intValue();
        }
        if (totalSamples == 0L) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(totalFailures).divide(new BigDecimal(totalSamples), MC);
    }

    public static List<BinomialPoint> calculateScatterData(List<Integer> failList, List<Integer> detectList, BigDecimal nBar, int decimalNum) {
        ArrayList<BigDecimal> results = new ArrayList<BigDecimal>();
        ArrayList<BinomialPoint> scatterData = new ArrayList<BinomialPoint>();
        for (int i = 0; i < failList.size(); ++i) {
            int d = failList.get(i);
            int n = detectList.get(i);
            BigDecimal a_i = new BigDecimal(d).divide(new BigDecimal(n), MC).multiply(nBar, MC);
            BigDecimal numerator = a_i.add(new BigDecimal("0.375"), MC);
            BigDecimal denominator = nBar.add(new BigDecimal("0.75"), MC);
            BigDecimal sqrtVal = CommonUtil.sqrt(numerator.divide(denominator, MC), MC);
            BigDecimal X_i = new BigDecimal(Math.asin(sqrtVal.doubleValue()), MC);
            results.add(X_i);
        }
        NormalDistribution standardNormal = new NormalDistribution(0.0, 1.0);
        results.sort(Comparator.comparing(BigDecimal::doubleValue));
        int totalSize = results.size();
        HashMap<Integer, BigDecimal> dataPoints = new HashMap<Integer, BigDecimal>();
        for (int i = 0; i < totalSize; ++i) {
            dataPoints.put(i, (BigDecimal)results.get(i));
        }
        Map<BigDecimal, Double> valueToRank = BinomialProbabilityUtil.calculateRanks(dataPoints);
        for (int i = 0; i < totalSize; ++i) {
            BigDecimal x = (BigDecimal)results.get(i);
            double avgRank = valueToRank.get(x);
            int rank = i + 1;
            BigDecimal y = new BigDecimal((double)rank - 0.3).divide(new BigDecimal((double)failList.size() + 0.4), MC);
            BigDecimal avgY = new BigDecimal(avgRank - 0.3).divide(new BigDecimal((double)failList.size() + 0.4), MC);
            BigDecimal z = BigDecimal.valueOf(standardNormal.inverseCumulativeProbability(y.doubleValue()));
            BigDecimal avgZ = BigDecimal.valueOf(standardNormal.inverseCumulativeProbability(avgY.doubleValue()));
            scatterData.add(new BinomialPoint(x, y.multiply(BigDecimal.valueOf(100L)), z, avgZ));
        }
        return scatterData;
    }

    public static BigDecimal calculateSampleStdDev(BigDecimal nBar) {
        BigDecimal fourTimesMeanN = nBar.multiply(new BigDecimal("4"));
        BigDecimal squareRoot = Calc.getBigDecimal(Math.sqrt(fourTimesMeanN.doubleValue()));
        return BigDecimal.ONE.divide(squareRoot, MC);
    }

    public static BigDecimal calculateObservedVariation(List<BinomialPoint> scatterData) {
        NormalDistribution standardNormal = new NormalDistribution(0.0, 1.0);
        List<Double> xList = scatterData.stream().map(x -> Calc.tidyDecimal(x.getX(), 3, true).doubleValue()).collect(Collectors.toList());
        List yList = scatterData.stream().map(y -> Calc.tidyDecimal(y.getZ(), 8, true).doubleValue()).collect(Collectors.toList());
        double[] xArray = xList.stream().mapToDouble(Double::doubleValue).toArray();
        int n = xList.size();
        double q1 = BinomialProbabilityUtil.calculatePercentile(xList, 25.0);
        double q3 = BinomialProbabilityUtil.calculatePercentile(xList, 75.0);
        Percentile percentile = new Percentile();
        percentile.setData(xArray);
        ArrayList<Double> filteredX = new ArrayList<Double>();
        ArrayList<Double> filteredY = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            double x2 = xArray[i];
            double y2 = (Double)yList.get(i);
            if (!(x2 >= q1) || !(x2 <= q3)) continue;
            filteredX.add(x2);
            filteredY.add(y2);
        }
        if (filteredX.size() < 2) {
            throw new RuntimeException("\u7b5b\u9009\u540e\u7684\u6570\u636e\u70b9\u4e0d\u8db32\u4e2a\uff0c\u65e0\u6cd5\u62df\u5408\u7ebf\u6027\u56de\u5f52");
        }
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < filteredX.size(); ++i) {
            regression.addData(((Double)filteredX.get(i)).doubleValue(), ((Double)filteredY.get(i)).doubleValue());
        }
        double beta1 = regression.getSlope();
        if (Math.abs(beta1) < 1.0E-10) {
            throw new RuntimeException("\u03b2\u2081\u63a5\u8fd10\uff0c\u65e0\u6cd5\u8ba1\u7b971/\u03b2\u2081");
        }
        return new BigDecimal(1.0 / beta1, MC);
    }

    private static Map<BigDecimal, Double> calculateRanks(Map<Integer, BigDecimal> sortedPoints) {
        HashMap<BigDecimal, Double> valueToRank = new HashMap<BigDecimal, Double>();
        int i = 0;
        while (i < sortedPoints.size()) {
            int j;
            BigDecimal currentValue = sortedPoints.get(i);
            for (j = i; j < sortedPoints.size() && sortedPoints.get(j).compareTo(currentValue) == 0; ++j) {
            }
            double avgRank = 0.0;
            for (int k = i; k < j; ++k) {
                avgRank += (double)(k + 1);
            }
            valueToRank.put(currentValue, avgRank /= (double)(j - i));
            i = j;
        }
        return valueToRank;
    }

    private static double calculatePercentile(List<Double> data, double percentile) {
        ArrayList<Double> sortedData = new ArrayList<Double>(data);
        Collections.sort(sortedData);
        int n = sortedData.size();
        double pos = (double)(n + 1) * percentile / 100.0;
        if (pos <= 1.0) {
            return (Double)sortedData.get(0);
        }
        if (pos >= (double)n) {
            return (Double)sortedData.get(n - 1);
        }
        int k = (int)Math.floor(pos);
        double f = pos - (double)k;
        double x1 = (Double)sortedData.get(k - 1);
        double x2 = (Double)sortedData.get(k);
        return x1 + f * (x2 - x1);
    }

    public static double calculateZScore(double percentile) {
        double p = percentile > 0.5 ? 1.0 - percentile : percentile;
        double t = Math.sqrt(-2.0 * Math.log(p));
        double z = t - (2.515517 + 0.802853 * t + 0.010328 * t * t) / (1.0 + 1.432788 * t + 0.189269 * t * t + 0.001308 * t * t * t);
        return percentile > 0.5 ? z : -z;
    }
}

